/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.patrol.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.patrol.remote.PatrolRoutePointRemote;
import com.zkteco.zkbiosecurity.patrol.service.PatrolRoutePointService;
import com.zkteco.zkbiosecurity.patrol.vo.PatrolRoutePointItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PatrolRoutePointController
extends BaseController
implements PatrolRoutePointRemote {
    @Autowired
    private PatrolRoutePointService patrolRoutePointService;

    @RequiresPermissions(value={"patrol:routePoint:view"})
    public ModelAndView index() {
        return new ModelAndView("patrol/routePoint/patrolRoutePoint");
    }

    @RequiresPermissions(value={"patrol:routePoint:edit"})
    public ZKResultMsg save(PatrolRoutePointItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.patrolRoutePointService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public DxGrid list(PatrolRoutePointItem condition) {
        Pager pager = this.patrolRoutePointService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg delete(String ids) {
        this.patrolRoutePointService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getRoutePointIdsByRouteId(String routeId) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isNotBlank((CharSequence)routeId)) {
            List routePints = this.patrolRoutePointService.getPointIdsByRouteId(routeId);
            zkResultMsg.setData((Object)StringUtils.join((Iterable)routePints, (String)","));
        }
        return zkResultMsg;
    }
}

