/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.Pipe;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Random;
import sun.nio.ch.SinkChannelImpl;
import sun.nio.ch.SourceChannelImpl;

class PipeImpl
extends Pipe {
    private static final int NUM_SECRET_BYTES = 16;
    private static final Random RANDOM_NUMBER_GENERATOR = new SecureRandom();
    private Pipe.SourceChannel source;
    private Pipe.SinkChannel sink;

    PipeImpl(SelectorProvider sp) throws IOException {
        try {
            AccessController.doPrivileged(new Initializer(sp));
        }
        catch (PrivilegedActionException x) {
            throw (IOException)x.getCause();
        }
    }

    @Override
    public Pipe.SourceChannel source() {
        return this.source;
    }

    @Override
    public Pipe.SinkChannel sink() {
        return this.sink;
    }

    private class Initializer
    implements PrivilegedExceptionAction<Void> {
        private final SelectorProvider sp;
        private IOException ioe = null;

        private Initializer(SelectorProvider sp) {
            this.sp = sp;
        }

        @Override
        public Void run() throws IOException {
            LoopbackConnector connector = new LoopbackConnector();
            connector.run();
            if (this.ioe instanceof ClosedByInterruptException) {
                this.ioe = null;
                Thread connThread = new Thread((Runnable)connector){

                    @Override
                    public void interrupt() {
                    }
                };
                connThread.start();
                while (true) {
                    try {
                        connThread.join();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
                Thread.currentThread().interrupt();
            }
            if (this.ioe != null) {
                throw new IOException("Unable to establish loopback connection", this.ioe);
            }
            return null;
        }

        private class LoopbackConnector
        implements Runnable {
            private LoopbackConnector() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                AbstractInterruptibleChannel ssc = null;
                AbstractInterruptibleChannel sc1 = null;
                AbstractInterruptibleChannel sc2 = null;
                try {
                    ByteBuffer secret = ByteBuffer.allocate(16);
                    ByteBuffer bb = ByteBuffer.allocate(16);
                    InetAddress lb = InetAddress.getByName("127.0.0.1");
                    assert (lb.isLoopbackAddress());
                    InetSocketAddress sa = null;
                    while (true) {
                        if (ssc == null || !ssc.isOpen()) {
                            ssc = ServerSocketChannel.open();
                            ((ServerSocketChannel)ssc).socket().bind(new InetSocketAddress(lb, 0));
                            sa = new InetSocketAddress(lb, ((ServerSocketChannel)ssc).socket().getLocalPort());
                        }
                        sc1 = SocketChannel.open(sa);
                        RANDOM_NUMBER_GENERATOR.nextBytes(secret.array());
                        do {
                            ((SocketChannel)sc1).write(secret);
                        } while (secret.hasRemaining());
                        secret.rewind();
                        sc2 = ((ServerSocketChannel)ssc).accept();
                        do {
                            ((SocketChannel)sc2).read(bb);
                        } while (bb.hasRemaining());
                        bb.rewind();
                        if (bb.equals(secret)) break;
                        sc2.close();
                        sc1.close();
                    }
                    PipeImpl.this.source = new SourceChannelImpl(Initializer.this.sp, (SocketChannel)sc1);
                    PipeImpl.this.sink = new SinkChannelImpl(Initializer.this.sp, (SocketChannel)sc2);
                }
                catch (IOException e) {
                    try {
                        if (sc1 != null) {
                            sc1.close();
                        }
                        if (sc2 != null) {
                            sc2.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    Initializer.this.ioe = e;
                }
                finally {
                    try {
                        if (ssc != null) {
                            ssc.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

