/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import sun.awt.AWTAccessor;
import sun.awt.CausedFocusEvent;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;
import sun.java2d.pipe.Region;

final class WFileDialogPeer
extends WWindowPeer
implements FileDialogPeer {
    private WComponentPeer parent;
    private FilenameFilter fileFilter;
    private Vector<WWindowPeer> blockedWindows = new Vector();

    private static native void setFilterString(String var0);

    @Override
    public void setFilenameFilter(FilenameFilter filter) {
        this.fileFilter = filter;
    }

    boolean checkFilenameFilter(String filename) {
        FileDialog fileDialog = (FileDialog)this.target;
        if (this.fileFilter == null) {
            return true;
        }
        File file = new File(filename);
        return this.fileFilter.accept(new File(file.getParent()), file.getName());
    }

    WFileDialogPeer(FileDialog target) {
        super(target);
    }

    @Override
    void create(WComponentPeer parent) {
        this.parent = parent;
    }

    @Override
    protected void checkCreation() {
    }

    @Override
    void initialize() {
        this.setFilenameFilter(((FileDialog)this.target).getFilenameFilter());
    }

    private native void _dispose();

    @Override
    protected void disposeImpl() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    private native void _show();

    private native void _hide();

    @Override
    public void show() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                WFileDialogPeer.this._show();
            }
        }).start();
    }

    @Override
    void hide() {
        this._hide();
    }

    void setHWnd(long hwnd) {
        if (this.hwnd == hwnd) {
            return;
        }
        this.hwnd = hwnd;
        for (WWindowPeer window : this.blockedWindows) {
            if (hwnd != 0L) {
                window.modalDisable((Dialog)this.target, hwnd);
                continue;
            }
            window.modalEnable((Dialog)this.target);
        }
    }

    void handleSelected(char[] buffer) {
        String[] wFiles = new String(buffer).split("\u0000");
        boolean multiple = wFiles.length > 1;
        String jDirectory = null;
        String jFile = null;
        File[] jFiles = null;
        if (multiple) {
            jDirectory = wFiles[0];
            int filesNumber = wFiles.length - 1;
            jFiles = new File[filesNumber];
            for (int i = 0; i < filesNumber; ++i) {
                jFiles[i] = new File(jDirectory, wFiles[i + 1]);
            }
            jFile = wFiles[1];
        } else {
            int index = wFiles[0].lastIndexOf(File.separatorChar);
            if (index == -1) {
                jDirectory = "." + File.separator;
                jFile = wFiles[0];
            } else {
                jDirectory = wFiles[0].substring(0, index + 1);
                jFile = wFiles[0].substring(index + 1);
            }
            jFiles = new File[]{new File(jDirectory, jFile)};
        }
        final FileDialog fileDialog = (FileDialog)this.target;
        AWTAccessor.FileDialogAccessor fileDialogAccessor = AWTAccessor.getFileDialogAccessor();
        fileDialogAccessor.setDirectory(fileDialog, jDirectory);
        fileDialogAccessor.setFile(fileDialog, jFile);
        fileDialogAccessor.setFiles(fileDialog, jFiles);
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            @Override
            public void run() {
                fileDialog.setVisible(false);
            }
        });
    }

    void handleCancel() {
        final FileDialog fileDialog = (FileDialog)this.target;
        AWTAccessor.getFileDialogAccessor().setFile(fileDialog, null);
        AWTAccessor.getFileDialogAccessor().setFiles(fileDialog, null);
        AWTAccessor.getFileDialogAccessor().setDirectory(fileDialog, null);
        WToolkit.executeOnEventHandlerThread(fileDialog, new Runnable(){

            @Override
            public void run() {
                fileDialog.setVisible(false);
            }
        });
    }

    void blockWindow(WWindowPeer window) {
        this.blockedWindows.add(window);
        if (this.hwnd != 0L) {
            window.modalDisable((Dialog)this.target, this.hwnd);
        }
    }

    void unblockWindow(WWindowPeer window) {
        this.blockedWindows.remove(window);
        if (this.hwnd != 0L) {
            window.modalEnable((Dialog)this.target);
        }
    }

    @Override
    public void blockWindows(List<Window> toBlock) {
        for (Window w : toBlock) {
            WWindowPeer wp = (WWindowPeer)AWTAccessor.getComponentAccessor().getPeer(w);
            if (wp == null) continue;
            this.blockWindow(wp);
        }
    }

    @Override
    public native void toFront();

    @Override
    public native void toBack();

    @Override
    public void updateAlwaysOnTopState() {
    }

    @Override
    public void setDirectory(String dir) {
    }

    @Override
    public void setFile(String file) {
    }

    @Override
    public void setTitle(String title) {
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    void enable() {
    }

    @Override
    void disable() {
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
    }

    public boolean handleEvent(Event e) {
        return false;
    }

    @Override
    public void setForeground(Color c) {
    }

    @Override
    public void setBackground(Color c) {
    }

    @Override
    public void setFont(Font f) {
    }

    @Override
    public void updateMinimumSize() {
    }

    @Override
    public void updateIconImages() {
    }

    public boolean requestFocus(boolean temporary, boolean focusedWindowChangeAllowed) {
        return false;
    }

    @Override
    public boolean requestFocus(Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, CausedFocusEvent.Cause cause) {
        return false;
    }

    @Override
    void start() {
    }

    @Override
    public void beginValidate() {
    }

    @Override
    public void endValidate() {
    }

    void invalidate(int x, int y, int width, int height) {
    }

    @Override
    public void addDropTarget(DropTarget dt) {
    }

    @Override
    public void removeDropTarget(DropTarget dt) {
    }

    @Override
    public void updateFocusableWindowState() {
    }

    @Override
    public void setZOrder(ComponentPeer above) {
    }

    private static native void initIDs();

    @Override
    public void applyShape(Region shape) {
    }

    @Override
    public void setOpacity(float opacity) {
    }

    @Override
    public void setOpaque(boolean isOpaque) {
    }

    public void updateWindow(BufferedImage backBuffer) {
    }

    @Override
    public void createScreenSurface(boolean isResize) {
    }

    @Override
    public void replaceSurfaceData() {
    }

    public boolean isMultipleMode() {
        FileDialog fileDialog = (FileDialog)this.target;
        return AWTAccessor.getFileDialogAccessor().isMultipleMode(fileDialog);
    }

    static {
        WFileDialogPeer.initIDs();
        String filterString = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                try {
                    ResourceBundle rb = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
                    return rb.getString("allFiles");
                }
                catch (MissingResourceException e) {
                    return "All Files";
                }
            }
        });
        WFileDialogPeer.setFilterString(filterString);
    }
}

