/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicDesktopIconUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthInternalFrameTitlePane;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthUI;

public class SynthDesktopIconUI
extends BasicDesktopIconUI
implements SynthUI,
PropertyChangeListener {
    private SynthStyle style;
    private Handler handler = new Handler();

    public static ComponentUI createUI(JComponent c) {
        return new SynthDesktopIconUI();
    }

    @Override
    protected void installComponents() {
        if (UIManager.getBoolean("InternalFrame.useTaskBar")) {
            this.iconPane = new JToggleButton(this.frame.getTitle(), this.frame.getFrameIcon()){

                @Override
                public String getToolTipText() {
                    return this.getText();
                }

                @Override
                public JPopupMenu getComponentPopupMenu() {
                    return SynthDesktopIconUI.this.frame.getComponentPopupMenu();
                }
            };
            ToolTipManager.sharedInstance().registerComponent(this.iconPane);
            this.iconPane.setFont(this.desktopIcon.getFont());
            this.iconPane.setBackground(this.desktopIcon.getBackground());
            this.iconPane.setForeground(this.desktopIcon.getForeground());
        } else {
            this.iconPane = new SynthInternalFrameTitlePane(this.frame);
            this.iconPane.setName("InternalFrame.northPane");
        }
        this.desktopIcon.setLayout(new BorderLayout());
        this.desktopIcon.add((Component)this.iconPane, "Center");
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.desktopIcon.addPropertyChangeListener(this);
        if (this.iconPane instanceof JToggleButton) {
            this.frame.addPropertyChangeListener(this);
            ((JToggleButton)this.iconPane).addActionListener(this.handler);
        }
    }

    @Override
    protected void uninstallListeners() {
        if (this.iconPane instanceof JToggleButton) {
            ((JToggleButton)this.iconPane).removeActionListener(this.handler);
            this.frame.removePropertyChangeListener(this);
        }
        this.desktopIcon.removePropertyChangeListener(this);
        super.uninstallListeners();
    }

    @Override
    protected void installDefaults() {
        this.updateStyle(this.desktopIcon);
    }

    private void updateStyle(JComponent c) {
        SynthContext context = this.getContext(c, 1);
        this.style = SynthLookAndFeel.updateStyle(context, this);
        context.dispose();
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext context = this.getContext(this.desktopIcon, 1);
        this.style.uninstallDefaults(context);
        context.dispose();
        this.style = null;
    }

    @Override
    public SynthContext getContext(JComponent c) {
        return this.getContext(c, this.getComponentState(c));
    }

    private SynthContext getContext(JComponent c, int state) {
        return SynthContext.getContext(c, this.style, state);
    }

    private int getComponentState(JComponent c) {
        return SynthLookAndFeel.getComponentState(c);
    }

    @Override
    public void update(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        SynthLookAndFeel.update(context, g);
        context.getPainter().paintDesktopIconBackground(context, g, 0, 0, c.getWidth(), c.getHeight());
        this.paint(context, g);
        context.dispose();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        SynthContext context = this.getContext(c);
        this.paint(context, g);
        context.dispose();
    }

    protected void paint(SynthContext context, Graphics g) {
    }

    @Override
    public void paintBorder(SynthContext context, Graphics g, int x, int y, int w, int h) {
        context.getPainter().paintDesktopIconBorder(context, g, x, y, w, h);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() instanceof JInternalFrame.JDesktopIcon) {
            if (SynthLookAndFeel.shouldUpdateStyle(evt)) {
                this.updateStyle((JInternalFrame.JDesktopIcon)evt.getSource());
            }
        } else if (evt.getSource() instanceof JInternalFrame) {
            JInternalFrame frame = (JInternalFrame)evt.getSource();
            if (this.iconPane instanceof JToggleButton) {
                JToggleButton button = (JToggleButton)this.iconPane;
                String prop = evt.getPropertyName();
                if (prop == "title") {
                    button.setText((String)evt.getNewValue());
                } else if (prop == "frameIcon") {
                    button.setIcon((Icon)evt.getNewValue());
                } else if (prop == "icon" || prop == "selected") {
                    button.setSelected(!frame.isIcon() && frame.isSelected());
                }
            }
        }
    }

    private final class Handler
    implements ActionListener {
        private Handler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if (evt.getSource() instanceof JToggleButton) {
                JToggleButton button = (JToggleButton)evt.getSource();
                try {
                    boolean selected = button.isSelected();
                    if (!selected && !SynthDesktopIconUI.this.frame.isIconifiable()) {
                        button.setSelected(true);
                    } else {
                        SynthDesktopIconUI.this.frame.setIcon(!selected);
                        if (selected) {
                            SynthDesktopIconUI.this.frame.setSelected(true);
                        }
                    }
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }
}

