/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.CharBuffer;
import java.util.Spliterator;
import java.util.function.IntConsumer;

class CharBufferSpliterator
implements Spliterator.OfInt {
    private final CharBuffer buffer;
    private int index;
    private final int limit;

    CharBufferSpliterator(CharBuffer buffer) {
        this(buffer, buffer.position(), buffer.limit());
    }

    CharBufferSpliterator(CharBuffer buffer, int origin, int limit) {
        assert (origin <= limit);
        this.buffer = buffer;
        this.index = origin <= limit ? origin : limit;
        this.limit = limit;
    }

    @Override
    public Spliterator.OfInt trySplit() {
        CharBufferSpliterator charBufferSpliterator;
        int lo = this.index;
        int mid = lo + this.limit >>> 1;
        if (lo >= mid) {
            charBufferSpliterator = null;
        } else {
            this.index = mid;
            CharBufferSpliterator charBufferSpliterator2 = new CharBufferSpliterator(this.buffer, lo, this.index);
            charBufferSpliterator = charBufferSpliterator2;
        }
        return charBufferSpliterator;
    }

    @Override
    public void forEachRemaining(IntConsumer action) {
        int hi;
        if (action == null) {
            throw new NullPointerException();
        }
        CharBuffer cb = this.buffer;
        int i = this.index;
        this.index = hi = this.limit;
        while (i < hi) {
            action.accept(cb.getUnchecked(i++));
        }
    }

    @Override
    public boolean tryAdvance(IntConsumer action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0 && this.index < this.limit) {
            action.accept(this.buffer.getUnchecked(this.index++));
            return true;
        }
        return false;
    }

    @Override
    public long estimateSize() {
        return this.limit - this.index;
    }

    @Override
    public int characteristics() {
        return 16464;
    }
}

