/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.JSSecurityManager;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import javax.sound.midi.spi.MidiDeviceProvider;
import javax.sound.midi.spi.MidiFileReader;
import javax.sound.midi.spi.MidiFileWriter;
import javax.sound.midi.spi.SoundbankReader;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Port;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.spi.AudioFileReader;
import javax.sound.sampled.spi.AudioFileWriter;
import javax.sound.sampled.spi.FormatConversionProvider;
import javax.sound.sampled.spi.MixerProvider;

public final class JDK13Services {
    private static final String PROPERTIES_FILENAME = "sound.properties";
    private static Properties properties;

    private JDK13Services() {
    }

    public static List<?> getProviders(Class<?> serviceClass) {
        List<?> providers = !MixerProvider.class.equals(serviceClass) && !FormatConversionProvider.class.equals(serviceClass) && !AudioFileReader.class.equals(serviceClass) && !AudioFileWriter.class.equals(serviceClass) && !MidiDeviceProvider.class.equals(serviceClass) && !SoundbankReader.class.equals(serviceClass) && !MidiFileWriter.class.equals(serviceClass) && !MidiFileReader.class.equals(serviceClass) ? new ArrayList(0) : JSSecurityManager.getProviders(serviceClass);
        return Collections.unmodifiableList(providers);
    }

    public static synchronized String getDefaultProviderClassName(Class typeClass) {
        int hashpos;
        String value = null;
        String defaultProviderSpec = JDK13Services.getDefaultProvider(typeClass);
        if (defaultProviderSpec != null && (hashpos = defaultProviderSpec.indexOf(35)) != 0) {
            value = hashpos > 0 ? defaultProviderSpec.substring(0, hashpos) : defaultProviderSpec;
        }
        return value;
    }

    public static synchronized String getDefaultInstanceName(Class typeClass) {
        int hashpos;
        String value = null;
        String defaultProviderSpec = JDK13Services.getDefaultProvider(typeClass);
        if (defaultProviderSpec != null && (hashpos = defaultProviderSpec.indexOf(35)) >= 0 && hashpos < defaultProviderSpec.length() - 1) {
            value = defaultProviderSpec.substring(hashpos + 1);
        }
        return value;
    }

    private static synchronized String getDefaultProvider(Class typeClass) {
        if (!(SourceDataLine.class.equals((Object)typeClass) || TargetDataLine.class.equals((Object)typeClass) || Clip.class.equals((Object)typeClass) || Port.class.equals((Object)typeClass) || Receiver.class.equals((Object)typeClass) || Transmitter.class.equals((Object)typeClass) || Synthesizer.class.equals((Object)typeClass) || Sequencer.class.equals((Object)typeClass))) {
            return null;
        }
        String name = typeClass.getName();
        String value = AccessController.doPrivileged(() -> System.getProperty(name));
        if (value == null) {
            value = JDK13Services.getProperties().getProperty(name);
        }
        if ("".equals(value)) {
            value = null;
        }
        return value;
    }

    private static synchronized Properties getProperties() {
        if (properties == null) {
            properties = new Properties();
            JSSecurityManager.loadProperties(properties, PROPERTIES_FILENAME);
        }
        return properties;
    }
}

