/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.io.Serializable;

@From(after="PSG_GATE t LEFT JOIN PSG_DEVICE d ON d.ID=t.DEV_ID ")
@OrderBy(after="d.BUSINESS_ID ASC, t.GATE_NO ASC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=450, operates={@GridOperate(type="edit", permission="psg:gate:edit", url="/psgGate.do?edit", label="common_op_edit")})
public class PsgGateItem
extends BaseItem
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(label="psg_gate_name", width="150", sortNo=1, columnType="edit", editPermission="psg:gate:edit", editUrl="/psgGate.do?edit")
    private String name;
    @Column(name="d.AUTH_AREA_ID", equalTag="=")
    private String authAreaId;
    @GridColumn(label="base_area_name", width="100", sortNo=2)
    private String authAreaName;
    @Column(name="t.DEV_ID")
    private String deviceId;
    @Column(name="d.GATE_TYPE")
    private String devMachineType;
    @Column(name="d.DEVICE_ALIAS")
    @GridColumn(label="common_ownedDev", width="150", sortNo=3)
    private String deviceAlias;
    @Column(name="d.SN")
    @GridColumn(label="common_dev_sn", width="150", sortNo=4)
    private String deviceSn;
    @Column(name="t.GATE_NO")
    @GridColumn(label="psg_gate_number", width="100", sortNo=5)
    private Short gateNo;
    @Column(name="t.ENABLED")
    @GridColumn(label="common_enable", width="60", sortNo=6, convert="convertToIcon", columnType="custom", showExpression="#language!='zh_CN'")
    private Boolean enabled;
    @Column(name="t.VERIFY_MODE")
    @GridColumn(label="common_verifyMode_entiy", width="150", sortNo=9, columnType="custom", convert="convertToVerifyModeName")
    private Short verifyMode;
    @Column(name="t.FORCE_PWD")
    private String forcePwd;
    @Column(name="t.SUPPER_PWD")
    private String supperPwd;
    @Column(name="t.READER_TYPE")
    private Short readerType;
    @Column(name="t.IS_DISABLE_AUDIO")
    private Boolean isDisableAudio;
    @Condition(value="t.ID", equalTag="in")
    private String inId;
    @Condition(value="t.ID", equalTag="not in")
    private String notId;
    @Condition(value="d.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIdIn;
    @Condition(value="d.ID IN (%s)", formatType="quote")
    private String devIdIn;

    public PsgGateItem() {
    }

    public PsgGateItem(Boolean equals) {
        super(equals);
    }

    public PsgGateItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getAuthAreaId() {
        return this.authAreaId;
    }

    public String getAuthAreaName() {
        return this.authAreaName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDevMachineType() {
        return this.devMachineType;
    }

    public String getDeviceAlias() {
        return this.deviceAlias;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public Short getGateNo() {
        return this.gateNo;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Short getVerifyMode() {
        return this.verifyMode;
    }

    public String getForcePwd() {
        return this.forcePwd;
    }

    public String getSupperPwd() {
        return this.supperPwd;
    }

    public Short getReaderType() {
        return this.readerType;
    }

    public Boolean getIsDisableAudio() {
        return this.isDisableAudio;
    }

    public String getInId() {
        return this.inId;
    }

    public String getNotId() {
        return this.notId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getDevIdIn() {
        return this.devIdIn;
    }

    public PsgGateItem setId(String id) {
        this.id = id;
        return this;
    }

    public PsgGateItem setName(String name) {
        this.name = name;
        return this;
    }

    public PsgGateItem setAuthAreaId(String authAreaId) {
        this.authAreaId = authAreaId;
        return this;
    }

    public PsgGateItem setAuthAreaName(String authAreaName) {
        this.authAreaName = authAreaName;
        return this;
    }

    public PsgGateItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public PsgGateItem setDevMachineType(String devMachineType) {
        this.devMachineType = devMachineType;
        return this;
    }

    public PsgGateItem setDeviceAlias(String deviceAlias) {
        this.deviceAlias = deviceAlias;
        return this;
    }

    public PsgGateItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public PsgGateItem setGateNo(Short gateNo) {
        this.gateNo = gateNo;
        return this;
    }

    public PsgGateItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public PsgGateItem setVerifyMode(Short verifyMode) {
        this.verifyMode = verifyMode;
        return this;
    }

    public PsgGateItem setForcePwd(String forcePwd) {
        this.forcePwd = forcePwd;
        return this;
    }

    public PsgGateItem setSupperPwd(String supperPwd) {
        this.supperPwd = supperPwd;
        return this;
    }

    public PsgGateItem setReaderType(Short readerType) {
        this.readerType = readerType;
        return this;
    }

    public PsgGateItem setIsDisableAudio(Boolean isDisableAudio) {
        this.isDisableAudio = isDisableAudio;
        return this;
    }

    public PsgGateItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public PsgGateItem setNotId(String notId) {
        this.notId = notId;
        return this;
    }

    public PsgGateItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public PsgGateItem setDevIdIn(String devIdIn) {
        this.devIdIn = devIdIn;
        return this;
    }
}

