/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.utils;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Date;
import java.util.Set;

public class CmdSecUtil {
    protected static char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String formatTime(String startTime, String endTime) {
        String[] startTimeArray = startTime.split(":");
        String[] endTimeArray = endTime.split(":");
        int start = Integer.parseInt(startTimeArray[0]) * 100 + Integer.parseInt(startTimeArray[1]);
        int end = Integer.parseInt(endTimeArray[0]) * 100 + Integer.parseInt(endTimeArray[1]);
        return String.valueOf((start << 16) + (end & 0xFFFF));
    }

    public static Boolean isC3Device(short machineType) {
        if (machineType == 4 || machineType == 1 || machineType == 2 || machineType == 7) {
            return true;
        }
        return false;
    }

    public static Boolean isStandaloneDevice(short machineType) {
        if (machineType == 101 || machineType == 102 || machineType == 103) {
            return true;
        }
        return false;
    }

    public static Long encodeTime(Date date) {
        date = date == null ? new Date() : date;
        long time = (long)((date.getYear() - 100) * 12 * 31 + date.getMonth() * 31 + (date.getDate() - 1)) * 86400L + (long)(date.getHours() * 60 * 60) + (long)(date.getMinutes() * 60) + (long)date.getSeconds();
        return time;
    }

    public static Long encodeDate(Date date) {
        long time = (long)(date.getYear() + 1900) * 10000L + (long)((date.getMonth() + 1) * 100) + (long)date.getDate();
        return time;
    }

    public static String substring(String orignal, int count) {
        try {
            if (orignal != null && !orignal.trim().equals("") && count > 0 && count < orignal.getBytes("UTF-8").length) {
                StringBuffer buff = new StringBuffer();
                for (int i = 0; i < orignal.length(); ++i) {
                    char c = orignal.charAt(i);
                    buff.append(c);
                    if (buff.toString().getBytes("UTF-8").length <= count) continue;
                    buff.deleteCharAt(buff.length() - 1);
                    break;
                }
                return buff.toString();
            }
        }
        catch (UnsupportedEncodingException e) {
            return orignal;
        }
        return orignal;
    }

    public static String formatDoorAuth(CmdDevice cmdDevice, Set<Short> doorNos) {
        switch (cmdDevice.getMachineType()) {
            case 11: {
                return CmdSecUtil.formatDoorAuthOfHex(doorNos);
            }
        }
        return CmdSecUtil.formatDoorAuthOfBin(doorNos);
    }

    private static String formatDoorAuthOfBin(Set<Short> doorNos) {
        assert (doorNos != null && doorNos.size() > 0);
        int authSum = 0;
        for (Short doorNo : doorNos) {
            authSum += (int)Math.pow(2.0, doorNo - 1);
        }
        return String.valueOf(authSum);
    }

    /*
     * WARNING - void declaration
     */
    private static String formatDoorAuthOfHex(Set<Short> doorNos) {
        void var3_5;
        int maxDoorNo = 0;
        for (int n : doorNos) {
            maxDoorNo = n > maxDoorNo ? n : maxDoorNo;
        }
        maxDoorNo += maxDoorNo % 4 != 0 ? 4 - maxDoorNo % 4 : 0;
        StringBuffer binBuf = new StringBuffer();
        boolean bl = false;
        while (var3_5 < maxDoorNo) {
            binBuf.append("0");
            ++var3_5;
        }
        for (short doorNo : doorNos) {
            binBuf.replace(doorNo - 1, doorNo, "1");
        }
        binBuf.reverse();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < maxDoorNo; i += 4) {
            String str = binBuf.substring(i, i + 4);
            stringBuffer.append(Integer.toHexString(Integer.parseInt(str, 2)));
        }
        return stringBuffer.toString().toUpperCase();
    }

    public static String toHex(int number) {
        return String.format("%02x", number);
    }

    public static String getFileMD5String(File file) throws Exception {
        FileInputStream fis = new FileInputStream(file);
        byte[] buffer = new byte[1024];
        int numRead = 0;
        MessageDigest messagedigest = MessageDigest.getInstance("MD5");
        while ((numRead = ((InputStream)fis).read(buffer)) > 0) {
            messagedigest.update(buffer, 0, numRead);
        }
        ((InputStream)fis).close();
        return CmdSecUtil.bufferToHex(messagedigest.digest());
    }

    private static String bufferToHex(byte[] bytes) {
        return CmdSecUtil.bufferToHex(bytes, 0, bytes.length);
    }

    private static String bufferToHex(byte[] bytes, int m, int n) {
        StringBuffer stringbuffer = new StringBuffer(2 * n);
        int k = m + n;
        for (int l = m; l < k; ++l) {
            CmdSecUtil.appendHexPair(bytes[l], stringbuffer);
        }
        return stringbuffer.toString();
    }

    private static void appendHexPair(byte bt, StringBuffer stringbuffer) {
        char charHigh4Bit = hexDigits[(bt & 0xF0) >> 4];
        char charLower4Bit = hexDigits[bt & 0xF];
        stringbuffer.append(charHigh4Bit);
        stringbuffer.append(charLower4Bit);
    }
}

