/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.cmd.sec.firstcard;

import com.zkteco.zkbiosecurity.cmd.sec.device.CmdDevice;
import com.zkteco.zkbiosecurity.cmd.sec.doorparameters.CmdDoorParameters;
import com.zkteco.zkbiosecurity.cmd.sec.doorparameters.CmdDoorParametersConstructor;
import com.zkteco.zkbiosecurity.cmd.sec.firstcard.CmdFirstCard;
import java.util.ArrayList;
import java.util.Collection;

public class CmdFirstCardConstructor {
    public static String setFirstCard(CmdDevice cmdDevice, Collection<CmdFirstCard> cmdFirstCards) {
        if (cmdFirstCards != null && cmdFirstCards.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            cmdFirstCards.forEach(cmdFirstCard -> {
                String cmd = String.format("DoorID=%d\tTimezoneID=%d\tPin=%s\r\n", cmdFirstCard.getDoorNo(), cmdFirstCard.getTimesegId(), cmdFirstCard.getPin());
                if ("1".equals(cmdDevice.getAccSupportFunList(26))) {
                    cmd = cmd.replace("\r\n", "\tDevID=" + cmdFirstCard.getDevId() + "\r\n");
                }
                cmdContent.append(cmd);
            });
            return CmdFirstCard.SET_FIRSTPERSON_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delFirstCard(CmdDevice cmdDevice, Collection<Short> doorNos) {
        if (doorNos != null && doorNos.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            doorNos.forEach(doorNo -> cmdContent.append(String.format("DoorID=%d\r\n", doorNo)));
            return CmdFirstCard.DEL_FIRSTPERSON_HEAD + cmdContent.toString();
        }
        return null;
    }

    public static String delAllFirstCard() {
        return CmdFirstCard.DEL_FIRSTPERSON_HEAD + "*\r\n";
    }

    private static String setFirstCardOption(CmdDevice cmdDevice, Collection<Short> doorNos, boolean openOrClose) {
        if (doorNos != null && doorNos.size() > 0) {
            StringBuffer cmdContent = new StringBuffer();
            ArrayList<CmdDoorParameters> cmdDoorParametersList = new ArrayList<CmdDoorParameters>();
            doorNos.forEach(doorNo -> {
                if ("1".equals(cmdDevice.getAccSupportFunList(21))) {
                    cmdDoorParametersList.add(new CmdDoorParameters((Short)doorNo, "DoorFirstCardOpenDoor", openOrClose ? "1" : "0", cmdDevice.getId()));
                } else {
                    cmdContent.append(String.format("Door%sFirstCardOpenDoor=%s", doorNo, openOrClose ? "1" : "0") + ",");
                }
            });
            if ("1".equals(cmdDevice.getAccSupportFunList(21))) {
                return CmdDoorParametersConstructor.setDoorParameters(cmdDevice, cmdDoorParametersList);
            }
            String tempCmd = cmdContent.toString();
            return "SET OPTIONS " + tempCmd.substring(0, tempCmd.length() - 1) + "\r\n";
        }
        return null;
    }

    public static String enableFirstCard(CmdDevice cmdDevice, Collection<Short> doorNos) {
        return CmdFirstCardConstructor.setFirstCardOption(cmdDevice, doorNos, true);
    }

    public static String disableFirstCard(CmdDevice cmdDevice, Collection<Short> doorNos) {
        return CmdFirstCardConstructor.setFirstCardOption(cmdDevice, doorNos, false);
    }
}

