/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_TRANSACTION t ")
@OrderBy(after="t.ATT_DATETIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class AttTransactionItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(show=false, sortNo=0)
    private String id;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", width="120", sortNo=1)
    private String personPin;
    @Column(name="t.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="120", sortNo=2)
    private String personName;
    @Column(name="t.PERS_PERSON_LAST_NAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="120", sortNo=3)
    private String personLastName;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    @Column(name="t.AUTH_DEPT_CODE", equalTag="=")
    private String deptCode;
    @Column(name="t.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="150", sortNo=5)
    private String deptName;
    @Column(name="t.AUTH_AREA_ID", equalTag="=")
    @GridColumn(show=false)
    private String areaId;
    @Column(name="t.AUTH_AREA_NO")
    @GridColumn(show=false)
    private String areaNo;
    @Column(name="t.AUTH_AREA_NAME")
    @GridColumn(label="pers_person_attArea", sort="na", width="130", sortNo=6)
    private String areaName;
    @Column(name="t.DEVICE_ID", equalTag="=")
    @GridColumn(show=false)
    private String deviceId;
    @Column(name="t.DEVICE_SN")
    @GridColumn(label="common_dev_sn", width="130", sortNo=7)
    private String deviceSn;
    @Column(name="t.DEVICE_NAME")
    @GridColumn(label="common_dev_name", width="120", sortNo=8, showExpression="#language!='zh_CN'")
    private String deviceName;
    @GridColumn(label="att_attPoint_name", width="120", sortNo=8, showExpression="#language!='zh_CN'")
    private String pointName;
    @Column(name="t.DOOR_NO")
    @GridColumn(show=false)
    private Short doorNo;
    @Column(name="t.ATT_DATETIME")
    @GridColumn(label="att_statistical_attDatetime", width="150", sortNo=8)
    private Date attDatetime;
    @Column(name="t.ATT_DATE")
    @GridColumn(show=false)
    private String attDate;
    @Column(name="t.ATT_TIME")
    @GridColumn(show=false)
    private String attTime;
    @Column(name="t.ATT_STATE")
    @GridColumn(show=false)
    private String attState;
    @Column(name="t.ATT_VERIFY")
    @GridColumn(show=false)
    private String attVerify;
    @Column(name="t.MARK")
    @GridColumn(label="att_statistical_dataSources", format="att=att_statistical_att,acc=att_statistical_acc,park=att_statistical_park,ins=att_attPoint_ins,pid=att_attPoint_pid,api-FR=att_statistical_faceRecognition,app=att_statistical_app,vms=att_statistical_vms", sortNo=9, minWidth="210")
    private String mark;
    @Condition(value="t.ATT_DATETIME", equalTag=">=")
    private Date beginDate;
    @Condition(value="t.ATT_DATETIME", equalTag="<=")
    private Date endDate;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERS_PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Column(name="t.ATT_PLACE")
    @GridColumn(show=false)
    private String attPlace;
    @Column(name="t.DEVICE_SN", equalTag="in")
    private String deviceSnIn;
    @Condition(value="(t.mark = ''park'' or t.AUTH_AREA_ID IN ({0}))", formatType="quote")
    private String inAreaId;
    private String devName;
    @Column(name="t.MASK_FLAG")
    private String maskFlag;
    @Column(name="t.TEMPERATURE")
    private String temperature;
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startCreateTime;
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date endCreateTime;
    @Column(name="t.ATT_PHOTO_URL")
    @GridColumn
    private String attPhotoUrl;

    public AttTransactionItem() {
    }

    public AttTransactionItem(Boolean equals) {
        super(equals);
    }

    public AttTransactionItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttTransactionItem(String id, String deptId, String deptCode, String deptName, String personPin, String personName, String personLastName, String areaId, String areaNo, String areaName, String deviceId, String deviceSn, Short doorNo, Date attDatetime, String attDate, String attTime, String attState, String attVerify, String mark) {
        this.id = id;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.areaId = areaId;
        this.areaNo = areaNo;
        this.areaName = areaName;
        this.deviceId = deviceId;
        this.deviceSn = deviceSn;
        this.doorNo = doorNo;
        this.attDatetime = attDatetime;
        this.attDate = attDate;
        this.attTime = attTime;
        this.attState = attState;
        this.attVerify = attVerify;
        this.mark = mark;
    }

    public AttTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttTransactionItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttTransactionItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttTransactionItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttTransactionItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttTransactionItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public AttTransactionItem setAreaNo(String areaNo) {
        this.areaNo = areaNo;
        return this;
    }

    public AttTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public AttTransactionItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public AttTransactionItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public AttTransactionItem setDeviceName(String deviceName) {
        this.deviceName = deviceName;
        return this;
    }

    public AttTransactionItem setPointName(String pointName) {
        this.pointName = pointName;
        return this;
    }

    public AttTransactionItem setDoorNo(Short doorNo) {
        this.doorNo = doorNo;
        return this;
    }

    public AttTransactionItem setAttDatetime(Date attDatetime) {
        this.attDatetime = attDatetime;
        return this;
    }

    public AttTransactionItem setAttDate(String attDate) {
        this.attDate = attDate;
        return this;
    }

    public AttTransactionItem setAttTime(String attTime) {
        this.attTime = attTime;
        return this;
    }

    public AttTransactionItem setAttState(String attState) {
        this.attState = attState;
        return this;
    }

    public AttTransactionItem setAttVerify(String attVerify) {
        this.attVerify = attVerify;
        return this;
    }

    public AttTransactionItem setMark(String mark) {
        this.mark = mark;
        return this;
    }

    public AttTransactionItem setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public AttTransactionItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public AttTransactionItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttTransactionItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttTransactionItem setAttPlace(String attPlace) {
        this.attPlace = attPlace;
        return this;
    }

    public AttTransactionItem setDeviceSnIn(String deviceSnIn) {
        this.deviceSnIn = deviceSnIn;
        return this;
    }

    public AttTransactionItem setInAreaId(String inAreaId) {
        this.inAreaId = inAreaId;
        return this;
    }

    public AttTransactionItem setDevName(String devName) {
        this.devName = devName;
        return this;
    }

    public AttTransactionItem setMaskFlag(String maskFlag) {
        this.maskFlag = maskFlag;
        return this;
    }

    public AttTransactionItem setTemperature(String temperature) {
        this.temperature = temperature;
        return this;
    }

    public AttTransactionItem setStartCreateTime(Date startCreateTime) {
        this.startCreateTime = startCreateTime;
        return this;
    }

    public AttTransactionItem setEndCreateTime(Date endCreateTime) {
        this.endCreateTime = endCreateTime;
        return this;
    }

    public AttTransactionItem setAttPhotoUrl(String attPhotoUrl) {
        this.attPhotoUrl = attPhotoUrl;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaNo() {
        return this.areaNo;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public String getPointName() {
        return this.pointName;
    }

    public Short getDoorNo() {
        return this.doorNo;
    }

    public Date getAttDatetime() {
        return this.attDatetime;
    }

    public String getAttDate() {
        return this.attDate;
    }

    public String getAttTime() {
        return this.attTime;
    }

    public String getAttState() {
        return this.attState;
    }

    public String getAttVerify() {
        return this.attVerify;
    }

    public String getMark() {
        return this.mark;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getAttPlace() {
        return this.attPlace;
    }

    public String getDeviceSnIn() {
        return this.deviceSnIn;
    }

    public String getInAreaId() {
        return this.inAreaId;
    }

    public String getDevName() {
        return this.devName;
    }

    public String getMaskFlag() {
        return this.maskFlag;
    }

    public String getTemperature() {
        return this.temperature;
    }

    public Date getStartCreateTime() {
        return this.startCreateTime;
    }

    public Date getEndCreateTime() {
        return this.endCreateTime;
    }

    public String getAttPhotoUrl() {
        return this.attPhotoUrl;
    }
}

