/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.DateType;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_TEMPSCH t LEFT JOIN ATT_GROUP ag ON ag.ID = t.GROUP_ID LEFT JOIN ATT_PERSON ap ON ap.PERS_PERSON_ID = t.PERS_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=500, winWidth=650, operates={@GridOperate(type="edit", permission="att:tempsch:edit", url="attTempSch.do?edit", label="common_op_edit"), @GridOperate(type="del", permission="att:tempsch:del", url="attTempSch.do?del", click="flushAttTempSch", label="common_op_del")})
public class AttTempSchItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.TEMP_TYPE")
    @GridColumn(columnType="edit", label="att_schedule_tempType", format="0=att_common_group,1=att_common_dept,2=att_common_person", width="100", editUrl="/attTempSch.do?edit")
    private Short tempType;
    @Column(name="t.SCHEDULE_TYPE")
    private Short scheduleType;
    @Column(name="t.START_DATE", equalTag=">=")
    @DateType(type="date")
    @GridColumn(label="common_startTime", width="120")
    private Date startDate;
    @Column(name="t.END_DATE", equalTag="<=")
    @DateType(type="date")
    @GridColumn(label="common_endTime", width="120")
    private Date endDate;
    @GridColumn(label="att_shift_name", width="100", sort="na")
    private String shiftName;
    private String deptCode;
    @Column(name="ag.GROUP_NAME")
    @GridColumn(label="att_common_groupName", width="120")
    private String groupName;
    @GridColumn(label="pers_dept_deptName", sort="na", width="120")
    private String deptName;
    @Column(name="ap.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", sort="na", width="100")
    private String personName;
    @Column(name="ap.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.PERS_PERSON_PIN")
    @GridColumn(label="att_person_pin", sort="na", width="100")
    private String personPin;
    @Column(name="t.ATTENDANCE_MODE")
    @GridColumn(label="att_shift_attendanceMode", format="0=att_shift_shiftNormal,1=att_shift_oneDayOneCard,2=att_shift_onlyBrushTime,3=att_shift_notBrushCard", show=false)
    private Short attendanceMode;
    @Column(name="t.OVERTIME_MODE")
    @GridColumn(label="att_shift_overtimeMode", format="0=att_shift_autoCalc,1=att_shift_mustApply,2=att_shift_mustOvertime,3=att_shift_timeSmaller,4=att_shift_notOvertime", show=false)
    private Short overtimeMode;
    @Column(name="t.OVERTIME_REMARK")
    @GridColumn(label="att_shift_overtimeSign", format="0=att_shift_normal,1=att_shift_restday,2=common_leftMenu_holiday", show=false)
    private Short overtimeRemark;
    private String shiftNo;
    @Column(name="t.GROUP_ID")
    @GridColumn(show=false)
    private String groupId;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    @GridColumn(show=false)
    private String deptId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="(t.AUTH_DEPT_ID IN ({0}) or t.GROUP_ID IS NOT NULL)", formatType="quote")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    private String inGroupId;
    @Condition(value="(lower(ap.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(ap.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;

    public AttTempSchItem() {
    }

    public AttTempSchItem(Boolean equals) {
        super(equals);
    }

    public AttTempSchItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttTempSchItem(String id, Date startDate, Date endDate, Short scheduleType, Short tempType, Short attendanceMode, Short overtimeMode, Short overtimeRemark) {
        this.id = id;
        this.startDate = startDate;
        this.endDate = endDate;
        this.scheduleType = scheduleType;
        this.tempType = tempType;
        this.attendanceMode = attendanceMode;
        this.overtimeMode = overtimeMode;
        this.overtimeRemark = overtimeRemark;
    }

    public AttTempSchItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttTempSchItem setTempType(Short tempType) {
        this.tempType = tempType;
        return this;
    }

    public AttTempSchItem setScheduleType(Short scheduleType) {
        this.scheduleType = scheduleType;
        return this;
    }

    public AttTempSchItem setStartDate(Date startDate) {
        this.startDate = startDate;
        return this;
    }

    public AttTempSchItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public AttTempSchItem setShiftName(String shiftName) {
        this.shiftName = shiftName;
        return this;
    }

    public AttTempSchItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttTempSchItem setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public AttTempSchItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttTempSchItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttTempSchItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttTempSchItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttTempSchItem setAttendanceMode(Short attendanceMode) {
        this.attendanceMode = attendanceMode;
        return this;
    }

    public AttTempSchItem setOvertimeMode(Short overtimeMode) {
        this.overtimeMode = overtimeMode;
        return this;
    }

    public AttTempSchItem setOvertimeRemark(Short overtimeRemark) {
        this.overtimeRemark = overtimeRemark;
        return this;
    }

    public AttTempSchItem setShiftNo(String shiftNo) {
        this.shiftNo = shiftNo;
        return this;
    }

    public AttTempSchItem setGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public AttTempSchItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttTempSchItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttTempSchItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttTempSchItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttTempSchItem setInGroupId(String inGroupId) {
        this.inGroupId = inGroupId;
        return this;
    }

    public AttTempSchItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public Short getTempType() {
        return this.tempType;
    }

    public Short getScheduleType() {
        return this.scheduleType;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getShiftName() {
        return this.shiftName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public Short getAttendanceMode() {
        return this.attendanceMode;
    }

    public Short getOvertimeMode() {
        return this.overtimeMode;
    }

    public Short getOvertimeRemark() {
        return this.overtimeRemark;
    }

    public String getShiftNo() {
        return this.shiftNo;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInGroupId() {
        return this.inGroupId;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

