/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="ATT_OUT t LEFT JOIN ATT_PERSON p ON t.PERS_PERSON_ID=p.PERS_PERSON_ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={@GridOperate(type="del", permission="att:out:del", url="attOut.do?del&pins=(personPin)", label="common_op_del", filter="attApplyShowDel")})
public class AttOutItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na")
    private String id;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    @GridColumn(label="att_person_pin", width="100")
    private String personPin;
    @Column(name="p.PERS_PERSON_NAME")
    @GridColumn(label="att_person_name", width="100")
    private String personName;
    @Column(name="p.PERS_PERSON_LASTNAME")
    @GridColumn(label="att_person_lastName", showExpression="#language!='zh_CN'", width="100")
    private String personLastName;
    @GridColumn(label="att_common_deptNo", width="150", sort="na")
    private String deptCode;
    @GridColumn(label="att_common_deptName", width="150")
    private String deptName;
    @Column(name="t.START_DATETIME")
    @GridColumn(label="common_startTime", width="130")
    private Date startDatetime;
    @Column(name="t.END_DATETIME")
    @GridColumn(label="common_endTime", width="130")
    private Date endDatetime;
    @Column(name="t.OUT_LONG")
    @GridColumn(label="att_out_outLongMinute", width="170")
    private Integer outLong;
    @GridColumn(label="att_out_outLongDay", width="130", show=false)
    private String outLongDay;
    @GridColumn(label="att_out_outLongHour", width="130")
    private String outLongHour;
    @Column(name="t.REMARK")
    @GridColumn(label="common_remark", width="100")
    private String remark;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="att_common_operateTime", width="130")
    private Date operateDatetime;
    @Column(name="t.AUTH_DEPT_ID")
    private String deptId;
    @Column(name="t.PERS_PERSON_ID")
    private String personId;
    @Condition(value="t.CREATE_TIME", equalTag=">=")
    private Date startTime;
    @Condition(value="t.CREATE_TIME", equalTag="<=")
    private Date endTime;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.PERS_PERSON_ID", equalTag="in")
    private String inPersonId;
    @Condition(value="t.PERS_PERSON_PIN", equalTag="in")
    private String inPersonPin;
    @Condition(value="(lower(p.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(p.PERS_PERSON_LASTNAME) LIKE ''%{0}%'')")
    private String likeName;
    @Column(name="t.BUSINESS_KEY")
    private String businessKey;
    private String notifierPerIds;
    private String notifierPins;
    private String applyNo;
    private String applyType;
    @Column(name="t.FLOW_STATUS", equalTag="=")
    private String flowStatus;
    private String flowNo;
    @Condition(value="t.END_DATETIME", equalTag=">=")
    private Date startApplyDateTime;
    @Condition(value="t.START_DATETIME", equalTag="<=")
    private Date endApplyDateTime;
    private String comment;
    private String pass;

    public AttOutItem() {
    }

    public AttOutItem(Boolean equals) {
        super(equals);
    }

    public AttOutItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public AttOutItem setId(String id) {
        this.id = id;
        return this;
    }

    public AttOutItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public AttOutItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public AttOutItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public AttOutItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public AttOutItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public AttOutItem setStartDatetime(Date startDatetime) {
        this.startDatetime = startDatetime;
        return this;
    }

    public AttOutItem setEndDatetime(Date endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    public AttOutItem setOutLong(Integer outLong) {
        this.outLong = outLong;
        return this;
    }

    public AttOutItem setOutLongDay(String outLongDay) {
        this.outLongDay = outLongDay;
        return this;
    }

    public AttOutItem setOutLongHour(String outLongHour) {
        this.outLongHour = outLongHour;
        return this;
    }

    public AttOutItem setRemark(String remark) {
        this.remark = remark;
        return this;
    }

    public AttOutItem setOperateDatetime(Date operateDatetime) {
        this.operateDatetime = operateDatetime;
        return this;
    }

    public AttOutItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public AttOutItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public AttOutItem setStartTime(Date startTime) {
        this.startTime = startTime;
        return this;
    }

    public AttOutItem setEndTime(Date endTime) {
        this.endTime = endTime;
        return this;
    }

    public AttOutItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public AttOutItem setInPersonId(String inPersonId) {
        this.inPersonId = inPersonId;
        return this;
    }

    public AttOutItem setInPersonPin(String inPersonPin) {
        this.inPersonPin = inPersonPin;
        return this;
    }

    public AttOutItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public AttOutItem setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
        return this;
    }

    public AttOutItem setNotifierPerIds(String notifierPerIds) {
        this.notifierPerIds = notifierPerIds;
        return this;
    }

    public AttOutItem setNotifierPins(String notifierPins) {
        this.notifierPins = notifierPins;
        return this;
    }

    public AttOutItem setApplyNo(String applyNo) {
        this.applyNo = applyNo;
        return this;
    }

    public AttOutItem setApplyType(String applyType) {
        this.applyType = applyType;
        return this;
    }

    public AttOutItem setFlowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public AttOutItem setFlowNo(String flowNo) {
        this.flowNo = flowNo;
        return this;
    }

    public AttOutItem setStartApplyDateTime(Date startApplyDateTime) {
        this.startApplyDateTime = startApplyDateTime;
        return this;
    }

    public AttOutItem setEndApplyDateTime(Date endApplyDateTime) {
        this.endApplyDateTime = endApplyDateTime;
        return this;
    }

    public AttOutItem setComment(String comment) {
        this.comment = comment;
        return this;
    }

    public AttOutItem setPass(String pass) {
        this.pass = pass;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public Date getStartDatetime() {
        return this.startDatetime;
    }

    public Date getEndDatetime() {
        return this.endDatetime;
    }

    public Integer getOutLong() {
        return this.outLong;
    }

    public String getOutLongDay() {
        return this.outLongDay;
    }

    public String getOutLongHour() {
        return this.outLongHour;
    }

    public String getRemark() {
        return this.remark;
    }

    public Date getOperateDatetime() {
        return this.operateDatetime;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getPersonId() {
        return this.personId;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInPersonId() {
        return this.inPersonId;
    }

    public String getInPersonPin() {
        return this.inPersonPin;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public String getNotifierPerIds() {
        return this.notifierPerIds;
    }

    public String getNotifierPins() {
        return this.notifierPins;
    }

    public String getApplyNo() {
        return this.applyNo;
    }

    public String getApplyType() {
        return this.applyType;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getFlowNo() {
        return this.flowNo;
    }

    public Date getStartApplyDateTime() {
        return this.startApplyDateTime;
    }

    public Date getEndApplyDateTime() {
        return this.endApplyDateTime;
    }

    public String getComment() {
        return this.comment;
    }

    public String getPass() {
        return this.pass;
    }
}

