/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.psg.remote.PsgTransactionTodayRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgTransactionService;
import com.zkteco.zkbiosecurity.psg.vo.PsgTransactionTodayItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgTransactionTodayController
extends ExportController
implements PsgTransactionTodayRemote {
    @Autowired
    private PsgTransactionService psgTransactionService;

    @RequiresPermissions(value={"psg:transactionToday"})
    public ModelAndView index() {
        return new ModelAndView("psg/transactionToday/psgTransactionToday");
    }

    @RequiresPermissions(value={"psg:transactionToday:refresh"})
    public DxGrid list(PsgTransactionTodayItem condition) {
        condition.setStartTime(DateUtil.getTodayBeginTime());
        condition.setEndTime(DateUtil.getTodayEndTime());
        Pager pager = this.psgTransactionService.loadTodayTransactionByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:transactionToday:del"})
    public ZKResultMsg del(String ids) {
        this.psgTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:transactionToday:del"})
    @LogRequest(module="psg_module", object="psg_trans_today", opType="common_op_clearData", opContent="common_op_clearData")
    public ZKResultMsg clearData() {
        this.psgTransactionService.deleteAllDataByToday();
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"psg:transactionToday:export"})
    @LogRequest(module="psg_module", object="psg_trans_today", opType="common_op_export", opContent="common_op_export")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        PsgTransactionTodayItem psgTransactionTodayItem = new PsgTransactionTodayItem();
        this.setConditionValue((BaseItem)psgTransactionTodayItem);
        psgTransactionTodayItem.setStartTime(DateUtil.getTodayBeginTime());
        psgTransactionTodayItem.setEndTime(DateUtil.getTodayEndTime());
        String sessionId = request.getSession().getId();
        String areaNames = this.psgTransactionService.getAreaNamesByAuthFilter(sessionId);
        String deptCodes = this.psgTransactionService.getDeptCodesByAuthFilter(sessionId);
        psgTransactionTodayItem.setAreaNameIn(areaNames);
        psgTransactionTodayItem.setDeptCodeIn(deptCodes);
        List itemList = this.psgTransactionService.getItemData(PsgTransactionTodayItem.class, (BaseItem)psgTransactionTodayItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, PsgTransactionTodayItem.class);
    }
}

