/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.psg.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.psg.remote.PsgReaderRemote;
import com.zkteco.zkbiosecurity.psg.service.PsgChannelService;
import com.zkteco.zkbiosecurity.psg.service.PsgReaderService;
import com.zkteco.zkbiosecurity.psg.vo.PsgReaderItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PsgReaderController
extends BaseController
implements PsgReaderRemote {
    @Autowired
    private PsgReaderService psgReaderService;
    @Autowired
    private PsgChannelService psgChannelService;

    @RequiresPermissions(value={"psg:reader"})
    public ModelAndView index() {
        return new ModelAndView("psg/reader/psgReader");
    }

    @RequiresPermissions(value={"psg:reader:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            PsgReaderItem psgReaderItem = this.psgReaderService.getItemById(id);
            this.request.setAttribute("item", (Object)psgReaderItem);
        }
        return new ModelAndView("psg/reader/editPsgReader");
    }

    @RequiresPermissions(value={"psg:reader:edit"})
    @LogRequest(module="psg_module", object="common_leftMenu_reader", opType="common_op_edit", requestParams={"name"}, opContent="psg_readerDefine_readerName")
    public ZKResultMsg save(PsgReaderItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String applyTo = this.request.getParameter("applyTo");
        String readerModel = this.request.getParameter("readerModel");
        String readMode = this.request.getParameter("readMode");
        if (StringUtils.isBlank((CharSequence)applyTo)) {
            applyTo = "";
        }
        this.psgReaderService.saveItem(item, applyTo, readerModel, readMode);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"psg:reader:refresh"})
    public DxGrid list(PsgReaderItem condition) {
        Pager pager = this.psgReaderService.loadPagerByAuthFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"psg:reader:del"})
    public ZKResultMsg delete(String ids) {
        this.psgReaderService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public boolean isExist(PsgReaderItem item) {
        String readerName = this.request.getParameter("readerName");
        if (!readerName.equals(item.getName())) {
            return this.psgReaderService.isExist(item.getName());
        }
        return true;
    }

    public boolean isExistVid() {
        return this.psgReaderService.isExistVid();
    }

    public ModelAndView getChannelByEntityId() {
        String entityId = this.request.getParameter("entityId");
        this.request.setAttribute("entityId", (Object)entityId);
        this.request.setAttribute("entityName", (Object)"PsgReader");
        String channel2EntityIds = this.psgChannelService.getBindChannelIds(Arrays.asList(entityId), "PsgReader");
        this.request.setAttribute("value", (Object)channel2EntityIds);
        return new ModelAndView("psg/reader/psgReaderSelectChannelContent");
    }

    @RequiresPermissions(value={"psg:reader:bindChannel"})
    @LogRequest(module="psg_module", object="common_leftMenu_reader", opType="psg_common_bindOrUnbindChannel", requestParams={}, opContent="psg_common_bindOrUnbindChannel")
    public ZKResultMsg bindOrUnbindChannel() {
        String entityId = this.request.getParameter("entityId");
        String entityName = this.request.getParameter("entityName");
        String channelIds = this.request.getParameter("channelIds");
        ZKResultMsg ret = this.psgChannelService.bindOrUnbindChannel(channelIds, entityName, entityId);
        return I18nUtil.i18nMsg((ZKResultMsg)ret);
    }
}

