/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vid.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.GridOperate;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;

@From(after="VID_CHANNEL t LEFT JOIN VID_DEVICE vd ON t.DEV_ID = vd.ID")
@OrderBy(after="t.CREATE_TIME")
@GridConfig(operate=true, idField="id", winWidth=400, winHeight=225, operates={@GridOperate(type="edit", permission="vid:channel:edit", url="vidChannel.do?edit", label="common_op_edit")})
public class VidChannelItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sortNo=0)
    private String id;
    @Column(name="t.NAME")
    @GridColumn(columnType="edit", label="vid_channel_name", width="150", editUrl="vidChannel.do?edit")
    private String name;
    @Column(name="t.CHANNEL_NO")
    @GridColumn(label="vid_channel_num", width="100")
    private Short channelNo;
    @GridColumn(label="base_area_name", width="120")
    private String areaName;
    @Column(name="vd.AUTH_AREA_ID", equalTag="=")
    @GridColumn(show=false)
    private String areaId;
    @Column(name="vd.DEV_ALIAS")
    @GridColumn(label="common_dev_name", width="120")
    private String alias;
    @Column(name="vd.ID")
    @GridColumn(show=false)
    private String deviceId;
    @Column(name="t.ENABLED")
    @GridColumn(label="common_enable", width="80", convert="convertToIcon", columnType="custom")
    private Boolean enabled;
    @Column(name="t.ID", equalTag="in")
    private String inId;
    @Condition(value="vd.AUTH_AREA_ID IN (%s)", formatType="quote")
    private String areaIdIn;
    private String deviceSn;
    private String authAreaCode;

    public VidChannelItem() {
    }

    public VidChannelItem(Boolean equals) {
        super(equals);
    }

    public VidChannelItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public VidChannelItem(String id, String name, Short channelNo, String areaName, String areaId, String alias, Boolean enabled) {
        this.id = id;
        this.name = name;
        this.channelNo = channelNo;
        this.areaName = areaName;
        this.areaId = areaId;
        this.alias = alias;
        this.enabled = enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Short getChannelNo() {
        return this.channelNo;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getInId() {
        return this.inId;
    }

    public String getAreaIdIn() {
        return this.areaIdIn;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public String getAuthAreaCode() {
        return this.authAreaCode;
    }

    public VidChannelItem setId(String id) {
        this.id = id;
        return this;
    }

    public VidChannelItem setName(String name) {
        this.name = name;
        return this;
    }

    public VidChannelItem setChannelNo(Short channelNo) {
        this.channelNo = channelNo;
        return this;
    }

    public VidChannelItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public VidChannelItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public VidChannelItem setAlias(String alias) {
        this.alias = alias;
        return this;
    }

    public VidChannelItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public VidChannelItem setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public VidChannelItem setInId(String inId) {
        this.inId = inId;
        return this;
    }

    public VidChannelItem setAreaIdIn(String areaIdIn) {
        this.areaIdIn = areaIdIn;
        return this;
    }

    public VidChannelItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public VidChannelItem setAuthAreaCode(String authAreaCode) {
        this.authAreaCode = authAreaCode;
        return this;
    }

    public String toString() {
        return "VidChannelItem(id=" + this.getId() + ", name=" + this.getName() + ", channelNo=" + this.getChannelNo() + ", areaName=" + this.getAreaName() + ", areaId=" + this.getAreaId() + ", alias=" + this.getAlias() + ", deviceId=" + this.getDeviceId() + ", enabled=" + this.getEnabled() + ", inId=" + this.getInId() + ", areaIdIn=" + this.getAreaIdIn() + ", deviceSn=" + this.getDeviceSn() + ", authAreaCode=" + this.getAuthAreaCode() + ")";
    }
}

