/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDOfflineConsumeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDOfflineConsumeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDOfflineConsumeItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPersonOfflineConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDOfflineConsumeController
extends ExportController
implements PosIDOfflineConsumeRemote {
    @Autowired
    private PosIDOfflineConsumeService posIDOfflineConsumeService;

    @RequiresPermissions(value={"posid:offlineConsume"})
    public ModelAndView index() {
        return new ModelAndView("posid/offlineConsume/posIDOfflineConsume");
    }

    @RequiresPermissions(value={"posid:offlineConsume:refresh"})
    public DxGrid list(PosIDOfflineConsumeItem condition) {
        Pager pager = this.posIDOfflineConsumeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:offlineConsume:refresh"})
    public DxGrid personList(PosIDPersonOfflineConsumeItem condition) {
        Pager pager = this.posIDOfflineConsumeService.getPersonList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"posid:offlineConsume:verification"})
    public ModelAndView verification(String ids) {
        this.request.setAttribute("ids", (Object)ids);
        String retMessage = this.posIDOfflineConsumeService.chekVerification(ids);
        this.request.setAttribute("retMessage", (Object)retMessage);
        return new ModelAndView("posid/offlineConsume/verificationOfflineConsume");
    }

    @RequiresPermissions(value={"posid:offlineConsume:verification"})
    public ZKResultMsg passVerification(String ids) {
        ZKResultMsg res = this.posIDOfflineConsumeService.passVerification(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

