/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDMealConsumeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDMealConsumeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDMealConsumeExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDMealConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDMealConsumeController
extends ExportController
implements PosIDMealConsumeRemote {
    @Autowired
    private PosIDMealConsumeService posIDMealConsumeService;

    @RequiresPermissions(value={"posid:mealConsume"})
    public ModelAndView index() {
        return new ModelAndView("posid/mealConsume/posIDMealConsume");
    }

    @RequiresPermissions(value={"posid:mealConsume:refresh"})
    public DxGrid list(PosIDMealConsumeItem codition) {
        Pager pager = this.posIDMealConsumeService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:mealConsume:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDMealConsumeItem posIDMealConsumeItem = new PosIDMealConsumeItem();
        this.setConditionValue((BaseItem)posIDMealConsumeItem);
        List posIDMealConsumeExportItemList = this.posIDMealConsumeService.loadListByAuthFilter(posIDMealConsumeItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDMealConsumeExportItemList, PosIDMealConsumeExportItem.class);
    }
}

