/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.dashboard.controller;

import com.zkteco.zkbiosecurity.auth.controller.MainController;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.dashboard.remote.DashboardRemote;
import com.zkteco.zkbiosecurity.dashboard.service.DashboardService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class DashboardController
extends BaseController
implements DashboardRemote {
    @Autowired
    private DashboardService dashboardService;
    @Autowired
    private MainController mainController;
    @Value(value="${system.dashboardPath:dashboard}")
    private String dashboardUrl;

    public ModelAndView dashboard() {
        this.mainController.home();
        return new ModelAndView("dashboard/" + this.dashboardUrl);
    }

    private String getDashboardPage(String module) {
        String ret = SpringContextUtil.getApplicationContext().getEnvironment().getProperty("system.dashboard." + module);
        return StringUtils.isNotBlank((CharSequence)ret) ? ret : module + "Dashboard";
    }

    public ModelAndView accDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("acc"));
    }

    public ModelAndView attDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("att"));
    }

    public ModelAndView visDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("vis"));
    }

    public ModelAndView parkDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("park"));
    }

    public ModelAndView psgDashboard() {
        return new ModelAndView("dashboard/" + this.getDashboardPage("psg"));
    }

    public ZKResultMsg getDashboardData(String modeles, String timeType) {
        String psgAreaName = this.request.getParameter("psgAreaName");
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getDashboardData(modeles, timeType, psgAreaName));
    }

    public ZKResultMsg getDashboardMonitoringData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getDashboardMonitoringData());
    }

    public ZKResultMsg getBaseBioData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getBaseBioData());
    }

    public ZKResultMsg getAccEventTrendsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccEventTrendsData(timeType));
    }

    public ZKResultMsg getAccExceptionTopData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccExceptionTopData());
    }

    public ZKResultMsg getAccZoneData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAccZoneData());
    }

    public ZKResultMsg getAttWorkaholicData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttWorkaholicData(timeType));
    }

    public ZKResultMsg getAttTodayCountData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttTodayCountData());
    }

    public ZKResultMsg getAttTodayData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttTodayData());
    }

    public ZKResultMsg getAttExceptionCountData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getAttExceptionCountData());
    }

    public ZKResultMsg getVisDayTripsData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisDayTripsData());
    }

    public ZKResultMsg getVisitorTrendsData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisitorTrendsData());
    }

    public ZKResultMsg getVisRegistPointFlowData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisRegistPointFlowData());
    }

    public ZKResultMsg getVisitedListData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getVisitedListData());
    }

    public ZKResultMsg getParkRevenueData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getParkRevenueData(timeType));
    }

    public ZKResultMsg getParkRecordinData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getParkRecordinData());
    }

    @MessageMapping(value={"/dashboardRTMonitor/getEventData"})
    @SendTo(value={"/topic/dashboardRTMonitor/getEventData"})
    public Object getEventData(String _params) {
        return null;
    }

    public ZKResultMsg getPsgEventTrendsData(String timeType) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgEventTrendsData(timeType));
    }

    public ZKResultMsg getPsgExceptionTopData() {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgExceptionTopData());
    }

    public ZKResultMsg getPsgEventAlarmData(String psgAreaName) {
        return I18nUtil.i18nMsg((ZKResultMsg)this.dashboardService.getPsgEventAlaramData(psgAreaName));
    }
}

