/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.DIV;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKUIDirective(script="ui/js/ZKProcess.js")
public class Process
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        StringBuffer content = new StringBuffer();
        JSONObject options = new JSONObject();
        this.addRequestParams(options);
        BeanUtil.setParamsToJson(options, params);
        String id = BeanUtil.getParam(params, "id", "process" + BeanUtil.getUUID());
        options.put("id", (Object)id);
        String clientId = BeanUtil.getParam(params, "clientId", "clientId" + BeanUtil.getUUID());
        options.put("clientId", (Object)clientId);
        if (body != null) {
            JSONObject temp = (JSONObject)env.getCurrentNamespace().toMap().get("options");
            env.getCurrentNamespace().put("options", (Object)options);
            body.render(env.getOut());
            env.getCurrentNamespace().put("options", (Object)temp);
        }
        if (options.getJSONObject("next") != null) {
            content.append(this.appendNextContent(options));
        } else {
            HTMLElement doc = Document.createElement();
            doc.div().addAttributesOnly(params).id(id).addClass("dhx_process_box").appendContent(this.appendOpContent(options));
            doc.script().appendContent("new ZKUI.Process(" + options.toJSONString() + ");");
            content.append(doc.toString());
        }
        Writer out = env.getOut();
        out.write(content.toString());
    }

    private String appendOpContent(JSONObject options) {
        StringBuffer content = new StringBuffer();
        JSONObject opOpt = options.getJSONObject("op");
        String id = options.getString("id");
        if (opOpt != null) {
            content.append(opOpt.getString("body"));
            opOpt.remove((Object)"body");
            HTMLElement doc = Document.createElement();
            doc.div().style("width: 100%").text("&nbsp;");
            HTMLElement opFooter = doc.div().addClass("opFooter").appendChild(this.getProcessBar(options));
            HTMLElement btnDiv = opFooter.div().addClass("buttonDiv").style("height: 25px").id(id + "ButtonDiv");
            btnDiv.div().style("float: left;").attr("align", "left").button().addClass("button-form").id(id + "HideButton").text(I18nUtil.i18nCode((String)"common_op_hiddenInfo", (Object[])new Object[0]));
            btnDiv.div().style("float: left;color: red; margin-left: 50px;padding-top: 2px;").id(id + "CloseInfo");
            String confirmText = options.getString("confirmText");
            if (StringUtils.isEmpty((CharSequence)confirmText)) {
                confirmText = "common_dev_synchronize";
            }
            confirmText = I18nUtil.i18nCode((String)confirmText, (Object[])new Object[0]);
            HTMLElement closeDiv = btnDiv.div().style("float: right;").attr("align", "right");
            closeDiv.button().addClass("button-form").id(id + "ConfirmButton").text(confirmText);
            JSONObject closeBtn = options.getJSONObject("closeButton");
            if (closeBtn != null) {
                closeDiv.appendContent(closeBtn.getString("body"));
                closeBtn.remove((Object)"body");
            } else {
                closeDiv.button().addClass("button-form").id(id + "CloseButton").text(I18nUtil.i18nCode((String)"common_op_close", (Object[])new Object[0]));
            }
            opFooter.div().addClass("infoDiv").id(id + "InfoDiv");
            content.append(doc.toString());
        } else {
            HTMLElement doc = Document.createElement();
            HTMLElement opFooter = doc.div().addClass("opFooter").appendChild(this.getProcessBar(options));
            opFooter.div().addClass("infoDiv").id(id + "InfoDiv");
            HTMLElement btnDiv = opFooter.div().addClass("buttonDiv").id(id + "ButtonDiv");
            btnDiv.div().style("float: left;color: #7ac142;").attr("align", "left").id(id + "CloseInfo");
            HTMLElement closeDiv = btnDiv.div().style("float: right;").attr("align", "right");
            closeDiv.button().addClass("button-form").id(id + "StopButton").attr("disabled", "disabled").style("cursor: pointer;").text(I18nUtil.i18nCode((String)"common_op_delayClose", (Object[])new Object[0]));
            closeDiv.button().addClass("button-form").id(id + "CloseButton").text(I18nUtil.i18nCode((String)"common_op_close", (Object[])new Object[0]));
            content.append(doc.toString());
        }
        return content.toString();
    }

    private String appendNextContent(JSONObject options) {
        JSONObject nextBtn;
        StringBuffer content = new StringBuffer();
        JSONObject nextOpt = options.getJSONObject("next");
        String id = options.getString("id");
        if (nextOpt != null) {
            content.append(nextOpt.getString("body"));
            nextOpt.remove((Object)"body");
            DIV div = new DIV();
            div.addClass("nextProgress").style("background-color: #dcdfe2;padding: 10px;display: none");
            div.appendChild(this.getProcessBar(options));
            div.div().text(I18nUtil.i18nCode((String)"common_op_importLog", (Object[])new Object[0]));
            div.div().addClass("infoDiv").id(id + "InfoDiv");
        }
        if ((nextBtn = options.getJSONObject("nextButton")) != null) {
            content.append(nextBtn.getString("body"));
            nextBtn.remove((Object)"body");
        }
        return content.toString();
    }

    private HTMLElement getProcessBar(JSONObject options) {
        DIV div = new DIV();
        String id = options.getString("id");
        String type = options.getString("type");
        if (type == null || !type.equals("single")) {
            HTMLElement cur = div.div().style("height:40px;overflow: hidden;").id(id + "Current");
            cur.div().style("margin-bottom: 2px").span().id(id + "CurrentTitle").text(I18nUtil.i18nCode((String)"common_op_currProgress", (Object[])new Object[0]));
            HTMLElement cp = cur.div().id(id + "CurrentProgress").addClass("progressBar");
            cp.span();
            cp.img().src("/public/images/searching.gif").attr("width", "14px").style("margin-top: -15px;float: right;display: none");
            cur.div().id(id + "CurrentText").addClass("progressBarText");
        }
        HTMLElement total = div.div().style("height:42px;overflow: hidden;").id(id + "Total");
        total.div().style("margin-bottom: 2px").span().id(id + "TotalTitle").text(I18nUtil.i18nCode((String)"common_op_totalProgress", (Object[])new Object[0]));
        HTMLElement tp = total.div().id(id + "TotalProgress").addClass("progressBar");
        tp.span();
        tp.img().src("/public/images/searching.gif").attr("width", "14px").style("margin-top: -15px;float: right;display: none");
        total.div().id(id + "TotalText").addClass("progressBarText");
        return div;
    }

    private void addRequestParams(JSONObject opts) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        if (StringUtils.isNotBlank((CharSequence)request.getParameter("useReq"))) {
            Enumeration names = request.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                opts.put(name, (Object)request.getParameter(name));
            }
        }
    }
}

