/*
 * Decompiled with CFR 0.152.
 */
package java.nio.channels.spi;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.InterruptibleChannel;
import sun.misc.SharedSecrets;
import sun.nio.ch.Interruptible;

public abstract class AbstractInterruptibleChannel
implements Channel,
InterruptibleChannel {
    private final Object closeLock = new Object();
    private volatile boolean open = true;
    private Interruptible interruptor;
    private volatile Thread interrupted;

    protected AbstractInterruptibleChannel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (!this.open) {
                return;
            }
            this.open = false;
            this.implCloseChannel();
        }
    }

    protected abstract void implCloseChannel() throws IOException;

    @Override
    public final boolean isOpen() {
        return this.open;
    }

    protected final void begin() {
        if (this.interruptor == null) {
            this.interruptor = new Interruptible(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void interrupt(Thread target) {
                    Object object = AbstractInterruptibleChannel.this.closeLock;
                    synchronized (object) {
                        if (AbstractInterruptibleChannel.this.closed) {
                            return;
                        }
                        AbstractInterruptibleChannel.this.closed = true;
                        AbstractInterruptibleChannel.this.interrupted = target;
                        try {
                            AbstractInterruptibleChannel.this.implCloseChannel();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            };
        }
        AbstractInterruptibleChannel.blockedOn(this.interruptor);
        Thread thread = Thread.currentThread();
        if (thread.isInterrupted()) {
            this.interruptor.interrupt(thread);
        }
    }

    protected final void end(boolean bl) throws AsynchronousCloseException {
        AbstractInterruptibleChannel.blockedOn(null);
        Thread thread = this.interrupted;
        if (thread != null && thread == Thread.currentThread()) {
            thread = null;
            throw new ClosedByInterruptException();
        }
        if (!bl && !this.open) {
            throw new AsynchronousCloseException();
        }
    }

    static void blockedOn(Interruptible interruptible) {
        SharedSecrets.getJavaLangAccess().blockedOn(Thread.currentThread(), interruptible);
    }

    static /* synthetic */ Object access$000(AbstractInterruptibleChannel abstractInterruptibleChannel) {
        return abstractInterruptibleChannel.closeLock;
    }

    static /* synthetic */ boolean access$100(AbstractInterruptibleChannel abstractInterruptibleChannel) {
        return abstractInterruptibleChannel.open;
    }

    static /* synthetic */ boolean access$102(AbstractInterruptibleChannel abstractInterruptibleChannel, boolean bl) {
        abstractInterruptibleChannel.open = bl;
        return abstractInterruptibleChannel.open;
    }

    static /* synthetic */ Thread access$202(AbstractInterruptibleChannel abstractInterruptibleChannel, Thread thread) {
        abstractInterruptibleChannel.interrupted = thread;
        return abstractInterruptibleChannel.interrupted;
    }
}

