/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.park.sdkClient;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.park.service.ParkParamsService;
import com.zkteco.zkbiosecurity.park.utils.ParkWebCommonUtil;
import java.util.List;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ParkWebSocketSDKFun {
    private Logger logger = LoggerFactory.getLogger(ParkWebSocketSDKFun.class);
    private static Session session;
    @Autowired
    private ParkParamsService parkParamsService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSysInfo() {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("ZKWebSvrInfo");
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setParameter(String setParam) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    String fullDire = ParkWebCommonUtil.getSystemFilePathForSDK();
                    ParkWebCommonUtil.createDir(fullDire);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetParamInfo");
                    String devCount = this.parkParamsService.getLPRCount();
                    String countryCode = this.parkParamsService.getCountryCode();
                    String p2pSerAddr = this.parkParamsService.getP2PSerAddr();
                    String benableImage = "1";
                    if ("photoSavePath".equals(setParam)) {
                        devCount = "-1";
                        benableImage = "-1";
                    }
                    data.put("DevCount", (Object)devCount);
                    data.put("PicFilePath", (Object)fullDire);
                    data.put("BenableImage", (Object)benableImage);
                    data.put("CountryCode", (Object)countryCode);
                    data.put("P2PServerAddress", (Object)p2pSerAddr);
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getParameter() {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetParamInfo");
                    session.getBasicRemote().sendText(jsonInfo.toString());
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String startFindDevice() {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("StartFindDevice");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String stopFindDevice() {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("StopFindDevice");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deviceOpen(JSONObject devObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    session.getBasicRemote().sendText(devObj.toString());
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deviceClose(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("CloseDevice");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getFunlist(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    data.put("len", (Object)256);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetDeviceFunList");
                    jsonInfo.put("Data", (Object)data);
                    session.getAsyncRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDevVerInfo(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetDevVerInfo");
                    jsonInfo.put("Data", (Object)data);
                    session.getAsyncRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setDateTime(long handle, String newTime) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    data.put("DTInfo", (Object)newTime);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetDateTime");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String isDeviceConnected(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("IsDeviceConnected");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveSnapImage(long handle, String filePathName) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    data.put("FilePathName", (Object)filePathName);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SaveSnapImageToJpeg");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String openChannelGate(long handle, int chnId) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    String nDuration = this.parkParamsService.getOpenChannelTime();
                    data.put("Handle", (Object)handle);
                    data.put("ChnId", (Object)chnId);
                    data.put("NDuration", (Object)nDuration);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetIOOutputAuto");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialStart(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SerialStart");
                    data.put("Handle", (Object)handle);
                    data.put("SerialPort", (Object)"0");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialSend(long Serialhandle, byte[] pData) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SerialSend");
                    String base64Str = Base64Util.encode((byte[])pData);
                    base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
                    data.put("Serialhandle", (Object)Serialhandle);
                    data.put("Data", (Object)base64Str);
                    data.put("SizeData", (Object)base64Str.length());
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String serialStopSend(long Serialhandle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SerialStop");
                    data.put("Serialhandle", (Object)Serialhandle);
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPlateList(long handle, int t, byte[] pPlateList, int count, String opType) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson(opType);
                    String base64Str = Base64Util.encode((byte[])pPlateList);
                    base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
                    data.put("Handle", (Object)handle);
                    data.put("t", (Object)t);
                    data.put("PlateList", (Object)base64Str);
                    data.put("Count", (Object)count);
                    jsonInfo.put("Data", (Object)data);
                    if (this.parkParamsService.printParkLogger()) {
                        this.logger.info("PARK_SDK_SendMessage sendPlateList >>>>> " + jsonInfo.toString());
                    }
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sendPlateListForeign(long handle, int t, List<JSONObject> plateInfos, int count, String opType) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String ret = "-1";
            if (session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject data = new JSONObject();
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson(opType);
                    data.put("Handle", (Object)handle);
                    data.put("t", (Object)String.valueOf(t));
                    if ("DelPlateListExt".equals(opType) || "AddPlateListExt".equals(opType) || "AddPlateListExt".equals(opType)) {
                        data.put("Count", (Object)String.valueOf(count));
                        data.put("PlateList", plateInfos);
                        String base64Str = Base64Util.getBase64((String)data.toString());
                        base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
                        jsonInfo.put("Data", (Object)base64Str);
                    } else if ("ClearPlateListExt".equals(opType)) {
                        jsonInfo.put("Data", (Object)data);
                    }
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    ret = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCarTeamSignal(long handle) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetCarTeamSignal");
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setCarTeamSignal(long handle, int signal) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetCarTeamSignal");
                    JSONObject data = new JSONObject();
                    data.put("Handle", (Object)handle);
                    data.put("Signal", (Object)signal);
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String exportPlateList(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    String opType = "ExportPlateList";
                    if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                        opType = "ExportPlateListExt";
                    }
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson(opType);
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setOfflineParam(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetOfflineParam");
                    String base64Str = Base64Util.getBase64((String)paramObj);
                    base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
                    jsonInfo.put("Data", (Object)base64Str);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getOfflineParam(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetOfflineParam");
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String setDeviceData(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("SetDeviceData");
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceDataCount(JSONObject paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetDeviceDataCount");
                    jsonInfo.put("Data", (Object)paramObj);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDeviceData(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("GetDeviceData");
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String clearDeviceData(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("ClearDeviceData");
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String resetFactory(String paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("ResetFactory");
                    jsonInfo.put("Data", (Object)JSONObject.parseObject((String)paramObj));
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String rebootDevice(JSONObject paramObj) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getBaseJson("RebootDevice");
                    jsonInfo.put("Data", (Object)paramObj);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String connectDisplayDevice(String model, JSONObject data) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getDisplayBaseJson(model, "Connnet");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String sentDisplayData(String model, JSONObject data) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getDisplayBaseJson(model, "SentData");
                    String base64Str = Base64Util.getBase64((String)data.toString());
                    base64Str = base64Str.replaceAll("[\\s*\r\n]", "");
                    jsonInfo.put("Data", (Object)base64Str);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String closeDisplayDevice(String model, JSONObject data) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getDisplayBaseJson(model, "Close");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayDeviceStatus(String model, JSONObject data) {
        ParkWebSocketSDKFun parkWebSocketSDKFun = this;
        synchronized (parkWebSocketSDKFun) {
            String msgId = "-1";
            if (session != null && session.isOpen()) {
                try {
                    Thread.sleep(30L);
                    JSONObject jsonInfo = ParkWebCommonUtil.getDisplayBaseJson(model, "Status");
                    jsonInfo.put("Data", (Object)data);
                    session.getBasicRemote().sendText(jsonInfo.toString());
                    msgId = jsonInfo.getString("MsgId");
                }
                catch (Exception exception) {
                    this.logger.error("Session : " + session.getId() + " exception : " + exception.getMessage(), (Throwable)exception);
                }
            }
            return msgId;
        }
    }

    public Session getSession() {
        return session;
    }

    public void setSession(Session session) {
        ParkWebSocketSDKFun.session = session;
    }
}

