/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDTransactionRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDSystemParamService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionDetailService;
import com.zkteco.zkbiosecurity.posid.service.PosIDTransactionService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionDetailItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDTransactionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDTransactionController
extends ExportController
implements PosIDTransactionRemote {
    @Autowired
    private PosIDTransactionService posIDTransactionService;
    @Autowired
    private PosIDSystemParamService posIDSystemParamService;
    @Autowired
    private PosIDTransactionDetailService posIDTransactionDetailService;

    @RequiresPermissions(value={"posid:transaction"})
    public ModelAndView index() {
        return new ModelAndView("posid/transaction/posIDTransaction");
    }

    @RequiresPermissions(value={"posid:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDTransactionService.getItemById(id));
        }
        return new ModelAndView("posid/transaction/editPosIDTransaction");
    }

    @RequiresPermissions(value={"posid:transaction:edit"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_new", requestParams={"personPin"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:transaction:refresh"})
    public DxGrid list(PosIDTransactionItem codition) {
        Pager pager = this.posIDTransactionService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:transaction:del"})
    @LogRequest(module="posid_module", object="posid_transaction", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        this.posIDTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ModelAndView showDetailIndex(String transactionId) {
        HashMap<String, String> param = new HashMap<String, String>();
        Integer cardModel = this.posIDSystemParamService.getDoubleCash();
        param.put("transactionId", transactionId);
        return new ModelAndView("posid/transaction/posIDTransactionDetail", param);
    }

    public DxGrid showDetailList(String transactionId) {
        PosIDTransactionDetailItem posIDTransactionDetailItem = new PosIDTransactionDetailItem();
        posIDTransactionDetailItem.setTransactionId(transactionId);
        Pager pager = this.posIDTransactionDetailService.getItemsByPage((BaseItem)posIDTransactionDetailItem, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, posIDTransactionDetailItem.getClass());
    }

    @RequiresPermissions(value={"posid:transaction:errorRecovery"})
    public ZKResultMsg errorRecoveryData(String ids) {
        ZKResultMsg zKResultMsg = this.posIDTransactionService.errorRecoveryData(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)zKResultMsg);
    }

    @RequiresPermissions(value={"posid:transaction:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDTransactionItem posIDTransactionItem = new PosIDTransactionItem();
        this.setConditionValue((BaseItem)posIDTransactionItem);
        List posIDTransactionExportItemList = this.posIDTransactionService.loadListByAuthFilter(posIDTransactionItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDTransactionExportItemList, PosIDTransactionExportItem.class);
    }
}

