/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDPurchaseRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDPurchaseService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDPurchaseItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDPurchaseController
extends ExportController
implements PosIDPurchaseRemote {
    @Autowired
    private PosIDPurchaseService posIDPurchaseService;

    @RequiresPermissions(value={"posid:purchase"})
    public ModelAndView index() {
        return new ModelAndView("posid/purchase/posIDPurchase");
    }

    @RequiresPermissions(value={"posid:purchase:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.posIDPurchaseService.getItemById(id));
        }
        return new ModelAndView("posid/purchase/editPosIDPurchase");
    }

    @RequiresPermissions(value={"posid:purchase:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_purchase", opType="common_op_new", requestParams={"deptName"}, opContent="posid_card_personNum")
    public ZKResultMsg save(PosIDPurchaseItem istem) {
        ZKResultMsg res = new ZKResultMsg();
        this.posIDPurchaseService.saveItem(istem);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"posid:purchase:refresh"})
    public DxGrid list(PosIDPurchaseItem codition) {
        Pager pager = this.posIDPurchaseService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }
}

