/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.posid.remote.PosIDDeviceConsumeRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDDeviceConsumeService;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceConsumeExportItem;
import com.zkteco.zkbiosecurity.posid.vo.PosIDDeviceConsumeItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDDeviceConsumeController
extends ExportController
implements PosIDDeviceConsumeRemote {
    @Autowired
    private PosIDDeviceConsumeService posIDDeviceConsumeService;

    @RequiresPermissions(value={"posid:deviceConsume"})
    public ModelAndView index() {
        return new ModelAndView("posid/deviceConsume/posIDDeviceConsume");
    }

    @RequiresPermissions(value={"posid:deviceConsume:refresh"})
    public DxGrid list(PosIDDeviceConsumeItem codition) {
        Pager pager = this.posIDDeviceConsumeService.loadPagerByAuthFilter(codition, this.getPageNo(), this.getPageSize(), this.request.getSession().getId());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"posid:deviceConsume:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) throws IllegalAccessException, InvocationTargetException {
        PosIDDeviceConsumeItem posIDDeviceConsumeItem = new PosIDDeviceConsumeItem();
        this.setConditionValue((BaseItem)posIDDeviceConsumeItem);
        List posIDDeviceConsumeExportItemList = this.posIDDeviceConsumeService.loadListByAuthFilter(posIDDeviceConsumeItem, this.getBeginIndex(), this.getEndIndex(), request.getSession().getId());
        this.excelExport(posIDDeviceConsumeExportItemList, PosIDDeviceConsumeExportItem.class);
    }
}

