/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.util;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.EncrypAESUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LicCompany;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.LicUidCard;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.Assert;

public class LicFileHelper {
    private static Logger logger = LoggerFactory.getLogger(LicFileHelper.class);
    public static final String LIC_PATH = "/license/biosecurity.lic";
    public static final String LIC_COMPANY = "lic_c";
    public static final String LIC_LICENSE = "lic_l";
    public static final String LIC_ID = "lic_id";
    public static final String LIC_UIDCARD = "lic_U";

    public static void updateModules(String licPath, List<LicModule> modules) {
        Assert.notNull(modules);
        CopyOnWriteArrayList<LicModule> modulesOld = new CopyOnWriteArrayList<LicModule>(LicFileHelper.readLicModules(licPath));
        for (LicModule module : modules) {
            if (StringUtils.isBlank((CharSequence)module.getId()) || StringUtils.isBlank((CharSequence)module.getLicenseNumber())) continue;
            LicModule moduleOld = null;
            for (int i = 0; i < modulesOld.size(); ++i) {
                if ((module.getId().equals(Module.MODULE_ACC_PULL.getId() + "") || module.getId().equals(Module.MODULE_ACC_C3.getId() + "")) && (((LicModule)modulesOld.get(i)).getId().equals(Module.MODULE_ACC_PULL.getId() + "") || ((LicModule)modulesOld.get(i)).getId().equals(Module.MODULE_ACC_C3.getId() + ""))) {
                    modulesOld.remove(i);
                    break;
                }
                if (!((LicModule)modulesOld.get(i)).getId().equals(module.getId())) continue;
                moduleOld = (LicModule)modulesOld.get(i);
                break;
            }
            if (moduleOld == null) {
                modulesOld.add(module);
                continue;
            }
            BeanUtils.copyProperties((Object)module, moduleOld);
        }
        LicFileHelper.writeLicModules(licPath, modulesOld);
    }

    public static void writeLicId(String licPath, String id) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)id);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_ID, LicFileHelper.encode(id));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicId(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            if (!p.containsKey(LIC_ID)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_ID));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readLicId(InputStream upload) {
        Properties p = new Properties();
        try {
            InputStream ins = upload;
            p.load(ins);
            ins.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("load lic file error");
        }
        try {
            if (!p.containsKey(LIC_ID)) {
                return "";
            }
            String id = LicFileHelper.decode(p.getProperty(LIC_ID));
            return StringUtils.trimToEmpty((String)id);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicCompany(String licPath, LicCompany company) {
        try {
            Assert.hasText((String)licPath);
            Assert.notNull((Object)company);
            String jsonComapny = JSONObject.toJSONString((Object)company);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_COMPANY, LicFileHelper.encode(jsonComapny));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicUidCard(String licPath, LicUidCard uidcard) {
        try {
            Assert.hasText((String)licPath);
            String jsonuidcard = JSONObject.toJSONString((Object)uidcard);
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            p.setProperty(LIC_UIDCARD, LicFileHelper.encode(jsonuidcard));
            LicFileHelper.saveLicFile(p, licPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LicCompany readLicCompany(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            String companyStr = p.getProperty(LIC_COMPANY);
            if (!StringUtils.isBlank((CharSequence)companyStr)) {
                return (LicCompany)JSONObject.parseObject((String)LicFileHelper.decode(companyStr), LicCompany.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LicCompany readLicCompany(InputStream upload) {
        block5: {
            try {
                Properties p = new Properties();
                if (upload == null) break block5;
                try {
                    InputStream ins = upload;
                    p.load(ins);
                    ins.close();
                }
                catch (Exception e) {
                    logger.error("", (Throwable)e);
                    throw new ZKBusinessException("load lic file error");
                }
                String companyStr = p.getProperty(LIC_COMPANY);
                if (!StringUtils.isBlank((CharSequence)companyStr)) {
                    return (LicCompany)JSONObject.parseObject((String)LicFileHelper.decode(companyStr), LicCompany.class);
                }
                return null;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static LicUidCard readLicUidCard(String licPath) {
        try {
            Properties p = LicFileHelper.getLicFileProperties(licPath);
            String uidcard = p.getProperty(LIC_UIDCARD);
            if (!StringUtils.isBlank((CharSequence)uidcard)) {
                return (LicUidCard)JSONObject.parseObject((String)LicFileHelper.decode(uidcard), LicUidCard.class);
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeLicModules(String licPath, List<LicModule> modules) {
        Assert.hasText((String)licPath);
        Assert.notNull(modules);
        String jsonModules = LicFileHelper.encode(JSONObject.toJSONString(modules));
        Properties p = LicFileHelper.getLicFileProperties(licPath);
        p.setProperty(LIC_LICENSE, jsonModules);
        LicFileHelper.saveLicFile(p, licPath);
    }

    public static List<LicModule> readLicModules(String licPath) {
        Properties p = LicFileHelper.getLicFileProperties(licPath);
        String modulesStr = p.getProperty(LIC_LICENSE);
        if (!StringUtils.isBlank((CharSequence)modulesStr)) {
            modulesStr = LicFileHelper.decode(modulesStr);
            return JSONObject.parseArray((String)modulesStr, LicModule.class);
        }
        return new ArrayList<LicModule>();
    }

    public static List<LicModule> readLicModules(InputStream upload) {
        Properties p = new Properties();
        try {
            InputStream ins = upload;
            p.load(ins);
            ins.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("load lic file error");
        }
        String modulesStr = p.getProperty(LIC_LICENSE);
        if (!StringUtils.isBlank((CharSequence)modulesStr)) {
            modulesStr = LicFileHelper.decode(modulesStr);
            return JSONObject.parseArray((String)modulesStr, LicModule.class);
        }
        return new ArrayList<LicModule>();
    }

    public static synchronized void deleteLicFile() {
        String path = LicFileHelper.getLicPath();
        File licFile = new File(path);
        if (licFile.exists()) {
            licFile.delete();
        }
    }

    public static synchronized void cleanLicCompanyAndLicense() {
        String path = LicFileHelper.getLicPath();
        Properties ps = LicFileHelper.getLicFileProperties(path);
        if (ps != null && ps.containsKey(LIC_COMPANY)) {
            ps.remove(LIC_COMPANY);
        }
        if (ps != null && ps.containsKey(LIC_LICENSE)) {
            ps.remove(LIC_LICENSE);
        }
        if (ps != null && ps.containsKey(LIC_ID)) {
            ps.remove(LIC_ID);
        }
        LicFileHelper.saveLicFile(ps, path);
    }

    private static synchronized Properties getLicFileProperties(String licPath) {
        Properties prop = new Properties();
        File licFile = new File(licPath);
        if (licFile.exists()) {
            try {
                FileInputStream ins = new FileInputStream(new File(licPath));
                prop.load(ins);
                ((InputStream)ins).close();
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
                throw new ZKBusinessException("load lic file error");
            }
        }
        return prop;
    }

    private static synchronized void saveLicFile(Properties prop, String licPath) {
        try {
            File licFile = new File(licPath);
            if (!licFile.exists()) {
                licFile.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(licFile);
            prop.store(out, "lic file");
            out.close();
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            throw new ZKBusinessException("save lic file error");
        }
    }

    public static String getLicPath() {
        return ClassUtil.getRootPath() + LIC_PATH;
    }

    private static String encode(String s) {
        String encodeStr = EncrypAESUtil.encrytToString((String)s);
        return encodeStr;
    }

    private static String decode(String s) {
        String decodeStr = EncrypAESUtil.decryptToString((String)s);
        return decodeStr;
    }
}

