/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.bean;

import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleType;

public enum Module {
    MODULE_VID(11, ModuleCode.VID, false, ModuleType.BUSSINESS),
    MODULE_ELE(12, ModuleCode.ELE, false, ModuleType.BUSSINESS),
    MODULE_VIS(13, ModuleCode.VIS, false, ModuleType.BUSSINESS),
    MODULE_PAT(14, ModuleCode.PAT, false, ModuleType.BUSSINESS),
    MODULE_HOTEL(15, ModuleCode.HOTEL, false, ModuleType.BUSSINESS),
    MODULE_ACC_PULL(10, ModuleCode.PULL, false, ModuleType.LICENSE),
    MODULE_ACC_ADVANCED(16, ModuleCode.ACCADVANCED, true, ModuleType.LICENSE),
    MODULE_ACC_PUSH(17, ModuleCode.PUSH, false, ModuleType.LICENSE),
    MODULE_ACC_C3(18, ModuleCode.C3, false, ModuleType.LICENSE),
    MODULE_LED(19, ModuleCode.LED, false, ModuleType.EXTEND),
    MODULE_PARK(21, ModuleCode.PARK, false, ModuleType.BUSSINESS),
    MODULE_ATT(20, ModuleCode.ATT, false, ModuleType.BUSSINESS),
    MODULE_ACC_ATT(22, ModuleCode.ACCATT, false, ModuleType.EXTEND),
    MODULE_ARTECO(23, ModuleCode.ARTECO, false, ModuleType.EXTEND),
    MODULE_C2P(24, ModuleCode.C2P, false, ModuleType.EXTEND),
    MODULE_OCR(25, ModuleCode.OCR, false, ModuleType.EXTEND),
    MODULE_AD(26, ModuleCode.AD, true, ModuleType.EXTEND),
    MODULE_PRINTCARD(27, ModuleCode.PRINTCARD, false, ModuleType.EXTEND),
    MODULE_API(28, ModuleCode.API, true, ModuleType.EXTEND),
    MODULE_APP(29, ModuleCode.APP, false, ModuleType.EXTEND),
    MODULE_PERS_ID_READER(30, ModuleCode.PERSIDREADER, false, ModuleType.EXTEND),
    MODULE_VIS_OCR(31, ModuleCode.VISOCR, false, ModuleType.EXTEND),
    MODULE_VIS_ID_READER(32, ModuleCode.VISIDREADER, false, ModuleType.EXTEND),
    MODULE_VIS_PRINT_CARD(33, ModuleCode.VISPRINTCARD, false, ModuleType.EXTEND),
    MODULE_HOTEL_OCR(34, ModuleCode.HOTELOCR, false, ModuleType.EXTEND),
    MODULE_HOTEL_ID_READER(35, ModuleCode.HOTELIDREADER, false, ModuleType.EXTEND),
    MODULE_HOTEL_PRINT_CARD(36, ModuleCode.HOTELPRINTCARD, false, ModuleType.EXTEND),
    MODULE_SYSTEM_PERS(37, ModuleCode.SYSTEMPERS, false, ModuleType.EXTEND),
    MODULE_SYSTEM_DEPARTMENT(38, ModuleCode.SYSTEMDEPARTMENT, false, ModuleType.EXTEND),
    MODULE_SYSTEM_AREA(39, ModuleCode.SYSTEMAREA, false, ModuleType.EXTEND),
    MODULE_PARKING_LPR_CAMERA(40, ModuleCode.PARKINGLPRCAMERA, false, ModuleType.EXTEND),
    MODULE_ACCESS_CONTROL_DOOR(41, ModuleCode.ACCESSCONTROLDOOR, false, ModuleType.EXTEND),
    MODULE_POS(42, ModuleCode.POS, false, ModuleType.BUSSINESS),
    MODULE_LCD(48, ModuleCode.LCD, true, ModuleType.EXTEND),
    MODULE_CARD_CONTROL(49, ModuleCode.CARDCONTROL, true, ModuleType.EXTEND),
    MODULE_PID(54, ModuleCode.PID, false, ModuleType.BUSSINESS),
    MODULE_PSG(55, ModuleCode.PSG, false, ModuleType.BUSSINESS),
    MODULE_INS(57, ModuleCode.INS, false, ModuleType.BUSSINESS),
    MODULE_INS_ATT(58, ModuleCode.INSATT, false, ModuleType.EXTEND),
    MODULE_AI(59, ModuleCode.AI, false, ModuleType.BUSSINESS),
    MODULE_PID_ATT(60, ModuleCode.PIDATT, false, ModuleType.EXTEND),
    MODULE_HOTEL_SIGNATURE(43, ModuleCode.HOTELSIGNATURE, false, ModuleType.EXTEND),
    MODULE_VIS_SIGNATURE(44, ModuleCode.VISSIGNATURE, false, ModuleType.EXTEND),
    MODULE_MIDDLE_TABLE(61, ModuleCode.MIDDLETABLE, true, ModuleType.EXTEND),
    MODULE_POSID(62, ModuleCode.POSID, false, ModuleType.BUSSINESS),
    MODULE_VMS(63, ModuleCode.VMS, false, ModuleType.BUSSINESS),
    MODULE_OA(64, ModuleCode.OA, true, ModuleType.BUSSINESS),
    MODULE_ICM(65, ModuleCode.ICM, false, ModuleType.BUSSINESS),
    MODULE_VIS_ADVANCED(45, ModuleCode.VISADVANCED, true, ModuleType.EXTEND),
    MODULE_GSMGPRSMODEM(69, ModuleCode.GSMGPRSMODEM, true, ModuleType.EXTEND),
    MODULE_THIRDSMS(47, ModuleCode.THIRDSMS, false, ModuleType.LICENSE),
    MODULE_VMS_ATT(67, ModuleCode.VMSATT, false, ModuleType.EXTEND),
    MODULE_LINE(68, ModuleCode.LINE, true, ModuleType.EXTEND),
    MODULE_CVA(70, ModuleCode.CVA, true, ModuleType.BUSSINESS),
    MODULE_ASSETS(72, ModuleCode.ASSETS, false, ModuleType.EXTEND),
    MODULE_FENCE(73, ModuleCode.FENCE, false, ModuleType.BUSSINESS),
    MODULE_DIGIFORT(66, ModuleCode.DIGIFORT, false, ModuleType.EXTEND),
    MODULE_VID_ATT(71, ModuleCode.VIDATT, false, ModuleType.EXTEND);

    private Integer id;
    private ModuleCode moduleCode;
    private String productCode = "5";
    private boolean numberLimit = false;
    private ModuleType moduleType = ModuleType.DEFAULT;

    public boolean canTrial() {
        if ("ZKBioAccess".equals(ModuleCode.productCode)) {
            return true;
        }
        return this.moduleCode != ModuleCode.C3;
    }

    public boolean isExists() {
        boolean exists = false;
        if (this.moduleType == ModuleType.BUSSINESS || this.moduleType == ModuleType.BUSSINESS) {
            // empty if block
        }
        return exists;
    }

    public static Module getByCode(String code) {
        for (Module m : Module.values()) {
            if (!m.getCode().equals(code)) continue;
            return m;
        }
        return null;
    }

    public static boolean containsCode(String code) {
        return Module.getByCode(code) != null;
    }

    public static String getIdCode(Integer id) {
        for (Module m : Module.values()) {
            if (!id.equals(m.getId())) continue;
            return m.getCode();
        }
        return null;
    }

    public static Module getById(Integer id) {
        for (Module m : Module.values()) {
            if (!id.equals(m.getId())) continue;
            return m;
        }
        return null;
    }

    public static boolean containsId(Integer id) {
        return Module.getById(id) != null;
    }

    public static boolean isMatch(String code, Integer id) {
        Module m = Module.getByCode(code);
        return id.equals(m.getId());
    }

    private Module(Integer id, ModuleCode moduleCode, boolean numberLimit, ModuleType moduleType) {
        this.id = id;
        this.moduleCode = moduleCode;
        this.numberLimit = numberLimit;
        this.moduleType = moduleType;
    }

    public String getCode() {
        return this.moduleCode.getCode();
    }

    public String getProductCode() {
        return this.productCode;
    }

    public Integer getId() {
        return this.id;
    }

    public ModuleCode getModuleCode() {
        return this.moduleCode;
    }

    public boolean isNumberLimit() {
        return this.numberLimit;
    }

    public ModuleType getModuleType() {
        return this.moduleType;
    }
}

