/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard;

import com.zkteco.guard.security.LicenseHelper;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.guard.LicenseCheckUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LangPack;
import com.zkteco.zkbiosecurity.guard.license.bean.LicInfo;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.bean.LicenseContext;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.util.LicCheckUtil2;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuthAcc;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuthDefault;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LicenseUtil {
    private static final Logger logger = LoggerFactory.getLogger(LicenseCheckUtil.class);
    public static final String LICENSE_HACK = "LICENSE_HACK";
    public static final String LICENSE_OVER_LIMIT = "LICENSE_OVER_LIMIT";
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    public static Map<String, Object> countMap = new HashMap<String, Object>();

    public LicenseUtil(IModuleAuth[] moduleAuths) {
        this.moduleAuths = moduleAuths;
    }

    public void initControlCount() {
        if (this.moduleAuths != null) {
            for (IModuleAuth moduleAuth : this.moduleAuths) {
                String systemCode = moduleAuth.module();
                if (moduleAuth instanceof IModuleAuthAcc) {
                    IModuleAuthAcc moduleAuthAcc = (IModuleAuthAcc)moduleAuth;
                    Map countParams = moduleAuthAcc.controlCount();
                    Integer pullGateCount = (Integer)countParams.get("pullGateCount");
                    Integer pullDevCount = (Integer)countParams.get("pullDevCount");
                    Integer pushGateCount = (Integer)countParams.get("pushGateCount");
                    Integer pushDevCount = (Integer)countParams.get("pushDevCount");
                    countMap.put("pull", pullDevCount);
                    countMap.put("c3", pullDevCount);
                    if (LicenseUtil.isLocal()) {
                        countMap.put("push", pushDevCount);
                        continue;
                    }
                    countMap.put("push", pullGateCount + pushGateCount);
                    continue;
                }
                IModuleAuthDefault moduleAuthDefault = (IModuleAuthDefault)moduleAuth;
                countMap.put(systemCode, moduleAuthDefault.controlCount());
            }
        }
    }

    public static LicenseContext getLicenseContext() {
        try {
            return LicenseHelper.getContext();
        }
        catch (Exception e) {
            logger.error("get LicenseContext exception", (Throwable)e);
            return null;
        }
    }

    public static boolean langMatch(int languagePack) {
        return ModuleCode.language.equals("zh_CN") ? languagePack == LangPack.CHINA.getLang() : languagePack != LangPack.CHINA.getLang();
    }

    public static boolean isLocal() {
        return "zh_CN".equals(ModuleCode.language);
    }

    public static int getSysProductCode() {
        String code = ModuleCode.productCode;
        if ("ZKBioAccess".equals(code)) {
            return 8;
        }
        return 5;
    }

    public static String getProductName() {
        int productCode = LicenseUtil.getSysProductCode();
        String productName = "";
        switch (productCode) {
            case 5: {
                productName = "BioSecurity";
                break;
            }
            case 6: {
                productName = "BioPack";
                break;
            }
            case 7: {
                productName = "BioLink";
                break;
            }
            case 8: {
                productName = "BioAccess";
                break;
            }
            default: {
                productName = "";
            }
        }
        if (!"true".equals(ModuleCode.systemOem)) {
            productName = "ZK" + productName;
        }
        return productName;
    }

    public static LicInfo filterByProductCode(LicInfo licInfo) {
        List<LicModule> modules = licInfo.getModules();
        LicModule module = null;
        ModuleBean bean = null;
        int productCode = LicenseUtil.getSysProductCode();
        if (modules != null) {
            for (int i = 0; i < modules.size(); ++i) {
                module = modules.get(i);
                if (module.getLicenseNumber() != null && !module.getLicenseNumber().equals("")) {
                    bean = LicCheckUtil2.getModuleBeanByNum(module.getLicenseNumber(), false);
                    if (bean != null && bean.getProductCode() != productCode) {
                        throw new ZKBusinessException("LicenseError:[" + LicenseUtil.getProductName() + "|License]");
                    }
                } else if (module.getSerialNumber() != null && !module.getSerialNumber().equals("") && (bean = LicCheckUtil2.getModuleBeanByNum(module.getSerialNumber(), true)) != null && bean.getProductCode() != productCode) {
                    throw new ZKBusinessException("LicenseError:[" + LicenseUtil.getProductName() + "|SN]");
                }
                if (bean == null || bean.getProductCode() == productCode) continue;
                modules.remove(i);
                --i;
            }
        }
        return licInfo;
    }

    public static int getTrialControlCount(String moduleCode) {
        if (LicenseUtil.isLocal()) {
            return LicenseUtil.getLocalTrialControlCount(moduleCode);
        }
        return LicenseUtil.getNonTrialControlCount(moduleCode);
    }

    private static int getNonTrialControlCount(String moduleCode) {
        if (Module.MODULE_ACC_PUSH.getCode().equals(moduleCode) && LicenseUtil.isLocal()) {
            return 2;
        }
        if (Module.MODULE_ACC_PUSH.getCode().equals(moduleCode) && !LicenseUtil.isLocal()) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 25;
            }
            return 50;
        }
        if (Module.MODULE_ACC_PULL.getCode().equals(moduleCode) && !LicenseUtil.isLocal()) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 10;
            }
            return 15;
        }
        if (Module.MODULE_ACC_C3.getCode().equals(moduleCode) || Module.MODULE_ACC_PULL.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 10;
            }
            return 50;
        }
        if (Module.MODULE_APP.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_VIS.getCode().equals(moduleCode)) {
            return 3;
        }
        if (Module.MODULE_ATT.getCode().equals(moduleCode) || Module.MODULE_VID_ATT.getCode().equals(moduleCode) || Module.MODULE_ACCESS_CONTROL_DOOR.getCode().equals(moduleCode) || Module.MODULE_POS.getCode().equals(moduleCode) || Module.MODULE_VMS_ATT.getCode().equals(moduleCode) || Module.MODULE_AI.getCode().equals(moduleCode) || Module.MODULE_PID.getCode().equals(moduleCode)) {
            return 5;
        }
        if (Module.MODULE_ELE.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_PAT.getCode().equals(moduleCode)) {
            return 8;
        }
        if (Module.MODULE_ACC_ATT.getCode().equals(moduleCode) || Module.MODULE_PSG.getCode().equals(moduleCode) || Module.MODULE_POSID.getCode().equals(moduleCode) || Module.MODULE_ICM.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_PARK.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_SYSTEM_PERS.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 2000;
            }
            return 30000;
        }
        if (Module.MODULE_SYSTEM_AREA.getCode().equals(moduleCode) || Module.MODULE_SYSTEM_DEPARTMENT.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 200;
            }
            return 1000;
        }
        if (Module.MODULE_INS.getCode().equals(moduleCode) || Module.MODULE_LED.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_VID.getCode().equals(moduleCode) || Module.MODULE_VMS.getCode().equals(moduleCode)) {
            return 16;
        }
        return 0;
    }

    private static int getLocalTrialControlCount(String moduleCode) {
        if (Module.MODULE_ACC_PUSH.getCode().equals(moduleCode) && LicenseUtil.isLocal()) {
            return 2;
        }
        if (Module.MODULE_ACC_PUSH.getCode().equals(moduleCode) && !LicenseUtil.isLocal()) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 10;
            }
            return 50;
        }
        if (Module.MODULE_ACC_PULL.getCode().equals(moduleCode) && !LicenseUtil.isLocal()) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 10;
            }
            return 0;
        }
        if (Module.MODULE_ACC_C3.getCode().equals(moduleCode) || Module.MODULE_ACC_PULL.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 10;
            }
            return 50;
        }
        if (Module.MODULE_VID.getCode().equals(moduleCode) || Module.MODULE_APP.getCode().equals(moduleCode)) {
            return 1;
        }
        if (Module.MODULE_VIS.getCode().equals(moduleCode) || Module.MODULE_ATT.getCode().equals(moduleCode)) {
            return 1;
        }
        if (Module.MODULE_ELE.getCode().equals(moduleCode)) {
            return 1;
        }
        if (Module.MODULE_PAT.getCode().equals(moduleCode)) {
            return 8;
        }
        if (Module.MODULE_AI.getCode().equals(moduleCode) || Module.MODULE_ACC_ATT.getCode().equals(moduleCode) || Module.MODULE_POS.getCode().equals(moduleCode) || Module.MODULE_PSG.getCode().equals(moduleCode) || Module.MODULE_POSID.getCode().equals(moduleCode) || Module.MODULE_VMS.getCode().equals(moduleCode) || Module.MODULE_ICM.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_PARK.getCode().equals(moduleCode) && LicenseUtil.isLocal()) {
            return 2;
        }
        if (Module.MODULE_SYSTEM_PERS.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 2000;
            }
            return 30000;
        }
        if (Module.MODULE_SYSTEM_AREA.getCode().equals(moduleCode) || Module.MODULE_SYSTEM_DEPARTMENT.getCode().equals(moduleCode)) {
            if ("ZKBioAccess".equals(ModuleCode.productCode)) {
                return 200;
            }
            return 1000;
        }
        if (Module.MODULE_PID.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_INS.getCode().equals(moduleCode)) {
            return 2;
        }
        if (Module.MODULE_FENCE.getCode().equals(moduleCode) || Module.MODULE_ASSETS.getCode().equals(moduleCode)) {
            return 2;
        }
        return 0;
    }

    public static int getLanguagePack() {
        int pack = LicenseUtil.getLicenseContext().getLanguagePack();
        if (pack >= 0) {
            return pack;
        }
        if (!LicenseUtil.isLocal()) {
            return LangPack.OVERSEA.getLang();
        }
        return LangPack.CHINA.getLang();
    }

    public static int getLeftTrialDay() {
        try {
            return LicenseHelper.countLeftDay();
        }
        catch (Exception e) {
            logger.error("exception", (Throwable)e);
            return -1;
        }
    }

    public static int getLeftTrialDay(String moduleCode) {
        return LicenseUtil.getLeftTrialDay();
    }

    public static int getDaysBetween(Date beginDate, Date endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        String bs = sdf.format(beginDate);
        String es = sdf.format(endDate);
        long bt = 0L;
        long et = 0L;
        try {
            Date bd = sdf.parse(bs);
            bt = bd.getTime();
        }
        catch (ParseException bd) {
            // empty catch block
        }
        try {
            Date ed = sdf.parse(es);
            et = ed.getTime();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return (int)((et - bt) / 86400000L);
    }

    public static int getNow() {
        Date now = new Date();
        String nowStr = new SimpleDateFormat("yyyyMMdd").format(now);
        return Integer.parseInt(nowStr);
    }

    public static void reloadLicense(IModuleAuth[] moduleAuths) {
        try {
            LicenseHelper.reloadLicense((IModuleAuth[])moduleAuths);
        }
        catch (Exception e) {
            throw new RuntimeException("reload license error", e);
        }
    }

    public static void initLicense(IModuleAuth[] moduleAuths) {
        try {
            LicenseHelper.init((IModuleAuth[])moduleAuths);
        }
        catch (Exception e) {
            throw new RuntimeException("init license error", e);
        }
    }

    public static void expiredLicense() {
        try {
            LicenseHelper.expiredLicense();
        }
        catch (Exception e) {
            logger.error("invoke expiredLicense method exception", (Throwable)e);
        }
    }

    public static void licenseCheckExpired(LicenseCheckInnerInvoke[] licenseCheckInnerInvoke) {
        try {
            if (licenseCheckInnerInvoke != null) {
                for (LicenseCheckInnerInvoke checkInnerInvoke : licenseCheckInnerInvoke) {
                    checkInnerInvoke.expired();
                }
            }
        }
        catch (ZKBusinessException e) {
            logger.info(e.getMessage());
        }
    }

    public static void promptLicenseOverLimit() {
        try {
            LicenseHelper.promptLicenseOverLimit();
        }
        catch (Exception e) {
            logger.error("invoke promptLicenseOverLimit method exception", (Throwable)e);
        }
    }

    public static void checkLicenseHack() {
        try {
            LicenseHelper.checkLicenseHack();
        }
        catch (Exception e) {
            logger.error("invoke checkLicenseHack method exception", (Throwable)e);
        }
    }

    public static void checkLicenseOverLimit(IModuleAuth[] moduleAuths) {
        try {
            LicenseHelper.checkLicenseOverLimit((IModuleAuth[])moduleAuths);
        }
        catch (Exception e) {
            logger.error("invoke checkLicenseOverLimit method exception", (Throwable)e);
        }
    }

    public static void checkLicense(IModuleAuth[] moduleAuths) {
        LicenseUtil.checkLicenseHack();
        LicenseUtil.checkLicenseOverLimit(moduleAuths);
    }
}

