/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitedDepartmentLevelRemote;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedDepartmentLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitedDepartmentLevelItem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VisVisitedDepartmentLevelController
extends BaseController
implements VisVisitedDepartmentLevelRemote {
    @Autowired
    private VisVisitedDepartmentLevelService visVisitedDepartmentLevelService;

    @RequiresPermissions(value={"vis:departmentLevel:refresh"})
    public DxGrid list(VisVisitedDepartmentLevelItem condition) {
        Pager pager = this.visVisitedDepartmentLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectDeptLevel"})
    @LogRequest(module="vis_module", object="vis_leftMenu_department", opType="vis_level_visitedLevel", requestParams={"code", "levelName"}, opContent="common_level_name")
    public ZKResultMsg addLevel() {
        String deptIdAndLevelIds = this.request.getParameter("deptIdAndLevelIds");
        this.visVisitedDepartmentLevelService.addLevel(deptIdAndLevelIds);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:departmentLevel:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_department", opType="common_op_del", requestParams={"code", "levelNames"}, opContent="common_level_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visVisitedDepartmentLevelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

