/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.vis.remote.VisTestServerRemote;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class VisTestServerController
extends BaseController
implements VisTestServerRemote {
    @Autowired
    private VisPlaceService visPlaceService;

    public ZKResultMsg testVisClientServer() {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg savePlace(VisPlaceItem item) {
        VisPlaceItem placeItem = null;
        if (StringUtils.isNotBlank((CharSequence)item.getPhysicalKey())) {
            VisPlaceItem visPlaceItem;
            placeItem = this.visPlaceService.getItemByPhysicalKey(item.getPhysicalKey());
            if (placeItem == null) {
                Map licenseMap = this.visPlaceService.checkPlaceLicense();
                if (!((String)licenseMap.get("licenseState")).equals("success")) {
                    if (((String)licenseMap.get("license")).equals("vis_message_maxLicensePlaceCount")) {
                        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("fail", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("licenseCount"), licenseMap.get("licenseCount")})));
                    }
                    return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("fail", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[0])));
                }
                placeItem = new VisPlaceItem();
                placeItem.setPhysicalKey(item.getPhysicalKey());
            }
            placeItem.setPlaceIp(item.getPlaceIp());
            placeItem.setVisMachineType(item.getVisMachineType());
            placeItem.setName(item.getName());
            if (StringUtils.isNotBlank((CharSequence)placeItem.getName()) && (visPlaceItem = this.visPlaceService.getItemByName(placeItem.getName())) != null && !visPlaceItem.getId().equals(placeItem.getId())) {
                return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("fail", I18nUtil.i18nCode((String)"vis_place_nameFail", (Object[])new Object[0])));
            }
            placeItem.setCertCaptureType("0");
            placeItem.setPhotoCaptureType("USB");
            placeItem.setAuthAreaId(this.visPlaceService.getInitAuthArea());
            placeItem = this.visPlaceService.saveItem(placeItem);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg(placeItem));
    }
}

