/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisReasonRemote;
import com.zkteco.zkbiosecurity.vis.service.VisReasonService;
import com.zkteco.zkbiosecurity.vis.vo.VisReasonItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisReasonController
extends BaseController
implements VisReasonRemote {
    @Autowired
    private VisReasonService visReasonService;

    @RequiresPermissions(value={"vis:reason"})
    public ModelAndView index() {
        return new ModelAndView("vis/reason/visReason");
    }

    @RequiresPermissions(value={"vis:reason:edit", "vis:reason:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visReasonService.getItemById(id));
        }
        return new ModelAndView("vis/reason/editVisReason");
    }

    @RequiresPermissions(value={"vis:reason:edit", "vis:reason:add"})
    @LogRequest(module="vis_module", object="vis_reason_name", opType="vis_reason_edit", requestParams={"name"}, opContent="vis_reason_name")
    public ZKResultMsg save(VisReasonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visReasonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:reason:refresh"})
    public DxGrid list(VisReasonItem condition) {
        Pager pager = this.visReasonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        List itemList = pager.getData();
        itemList.forEach(item -> item.setInitFlag());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:reason:del"})
    @LogRequest(module="vis_module", object="vis_reason_name", opType="vis_reason_del", requestParams={"names"}, opContent="vis_reason_del")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        VisReasonItem item = this.visReasonService.getItemByCode("visitReason");
        String[] idStr = ids.split(",");
        int len = idStr.length;
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.addAll(Arrays.asList(idStr));
        if (len > 0 && idsList.indexOf(item.getId()) > -1) {
            idsList.remove(item.getId());
            --len;
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        this.visReasonService.deleteByIds(StringUtils.join(idsList, (String)","));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public String validName(@RequestParam(value="name") String name) {
        VisReasonItem item = this.visReasonService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getReasonTree() {
        List visReasonItems = this.visReasonService.getByCondition(new VisReasonItem());
        ArrayList<SelectItem> selectItems = new ArrayList<SelectItem>();
        for (VisReasonItem visReasonItem : visReasonItems) {
            SelectItem selectItem = new SelectItem();
            selectItem.setValue(visReasonItem.getName());
            selectItem.setText((Object)visReasonItem.getName());
            selectItems.add(selectItem);
        }
        return new ZKResultMsg(selectItems);
    }
}

