/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisPrintTemplateRemote;
import com.zkteco.zkbiosecurity.vis.service.VisCardPrintTemplateService;
import com.zkteco.zkbiosecurity.vis.service.VisPrintTemplateService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisPrintTemplateController
extends BaseController
implements VisPrintTemplateRemote {
    @Autowired
    private VisPrintTemplateService visPrintTemplateService;
    @Autowired
    private VisCardPrintTemplateService visCardPrintTemplateService;

    @RequiresPermissions(value={"vis:printTemplate"})
    public ModelAndView index() {
        String printTemplate = this.visPrintTemplateService.getValByName("vis.printTemplate");
        if (StringUtils.isNotBlank((CharSequence)printTemplate)) {
            printTemplate = this.visCardPrintTemplateService.validTemplateId(printTemplate);
        }
        if (StringUtils.isBlank((CharSequence)printTemplate)) {
            printTemplate = this.visCardPrintTemplateService.getRceiptDefaultTemplateId();
        }
        this.request.setAttribute("printTemplate", (Object)printTemplate);
        this.request.setAttribute("isPrintReceipt", (Object)this.visPrintTemplateService.getValByName("vis.isPrintReceipt"));
        this.request.setAttribute("printingType", (Object)this.visPrintTemplateService.getValByName("vis.printingType"));
        return new ModelAndView("vis/printTemplate/visPrintTemplate");
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_printSettings", opType="common_op_edit", opContent="common_op_edit")
    public ZKResultMsg saveLocalSetting(@RequestParam Map<String, String> params) {
        this.visPrintTemplateService.saveLocalSetting(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

