/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisPlaceRemote;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisPrintParamService;
import com.zkteco.zkbiosecurity.vis.vo.VisPlaceItem;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisPlaceController
extends BaseController
implements VisPlaceRemote {
    @Autowired
    private VisPlaceService visPlaceService;
    @Autowired
    private VisPrintParamService visPrintParamService;

    @RequiresPermissions(value={"vis:place"})
    public ModelAndView index() {
        return new ModelAndView("vis/place/visPlace");
    }

    @RequiresPermissions(value={"vis:place:edit", "vis:place:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        VisPlaceItem item = new VisPlaceItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.visPlaceService.getItemById(id);
            this.request.setAttribute("authAreaId", (Object)item.getAuthAreaId());
            this.request.setAttribute("certCaptureType", (Object)item.getCertCaptureType());
        } else {
            String ip = this.request.getRemoteAddr();
            if ("0:0:0:0:0:0:0:1".equals(ip)) {
                ip = "127.0.0.1";
            }
            item.setPlaceIp(ip);
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("vis/place/editVisPlace");
    }

    @RequiresPermissions(value={"vis:place:edit", "vis:place:add"})
    @LogRequest(module="vis_module", object="vis_leftMenu_place", opType="vis_place_edit", requestParams={"placeIp", "name"}, opContent="vis_leftMenu_place")
    public ZKResultMsg save(VisPlaceItem item) {
        Map licenseMap = this.visPlaceService.checkPlaceLicense();
        if (!((String)licenseMap.get("licenseState")).equals("success") && StringUtils.isBlank((CharSequence)item.getId())) {
            if (((String)licenseMap.get("license")).equals("vis_message_maxLicensePlaceCount")) {
                return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("fail", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[]{licenseMap.get("licenseCount"), licenseMap.get("licenseCount")})));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg("fail", I18nUtil.i18nCode((String)((String)licenseMap.get("license")), (Object[])new Object[0])));
        }
        this.visPlaceService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:place:refresh"})
    public DxGrid list(VisPlaceItem condition) {
        Pager pager = this.visPlaceService.getItemsByPageFilterArea(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:place:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_place", opType="vis_place_del", requestParams={"placeIps"}, opContent="common_ipAddress")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        VisPlaceItem item = new VisPlaceItem();
        item.setInitFlag(Boolean.valueOf(true));
        List items = this.visPlaceService.getByCondition(item);
        item = items != null && !items.isEmpty() ? (VisPlaceItem)items.get(0) : null;
        String[] idStr = ids.split(",");
        int len = idStr.length;
        ArrayList<String> idsList = new ArrayList<String>();
        idsList.addAll(Arrays.asList(idStr));
        if (item != null && len > 0 && idsList.indexOf(item.getId()) > -1) {
            idsList.remove(item.getId());
            --len;
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"common_prompt_initDataCanNotDel", (Object[])new Object[0]));
        }
        this.visPlaceService.deleteByIds(StringUtils.join(idsList, (String)","));
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    public String validName(@RequestParam(value="name") String name) {
        VisPlaceItem item = this.visPlaceService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg validIPAddress() {
        ZKResultMsg res = new ZKResultMsg();
        String ip = this.request.getParameter("ip");
        String[] ipStr = ip.split("\\.");
        byte[] ipBuf = new byte[4];
        for (int i = 0; i < 4; ++i) {
            ipBuf[i] = (byte)(Integer.parseInt(ipStr[i]) & 0xFF);
        }
        try {
            InetAddress address = InetAddress.getByAddress(ipBuf);
            if (!address.isReachable(3000)) {
                res.setRet("fail");
                res.setMsg("vis_place_timeout");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg getPlaceList() {
        return new ZKResultMsg((Object)this.visPlaceService.getPlaceList());
    }

    public ZKResultMsg getChannelList() {
        return new ZKResultMsg((Object)this.visPlaceService.getChannelList());
    }

    public ZKResultMsg getCurrentPlace() {
        ZKResultMsg msg = new ZKResultMsg();
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        VisPlaceItem visPlaceItem = null;
        if (StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                visPlaceItem = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (visPlaceItem == null) continue;
                msg.setData((Object)visPlaceItem);
                break;
            }
        }
        if (visPlaceItem == null) {
            msg.setRet("500");
            msg.setMsg(I18nUtil.i18nCode((String)"vis_place_currentNotRegistration", (Object[])new Object[0]));
        }
        if (!this.visPlaceService.checkPlacePermission("vis:place:add", WebContextUtil.getCurrentSessionId()).booleanValue()) {
            msg.setRet("400");
        }
        return msg;
    }

    public ZKResultMsg getDefaultLevel(@RequestParam(value="placeId", required=false) String placeId) {
        VisPlaceItem item = null;
        Map paramMap = new HashMap();
        String cpuData = this.request.getParameter("cpuData");
        String macData = this.request.getParameter("macData");
        if (StringUtils.isBlank((CharSequence)placeId) && StringUtils.isNotBlank((CharSequence)macData)) {
            String[] macDatas;
            for (String mac : macDatas = macData.split(",")) {
                item = this.visPlaceService.getItemByPhysicalKey(cpuData + mac);
                if (item == null) continue;
                paramMap = this.visPrintParamService.getPrintParams(item.getId());
                break;
            }
        } else {
            item = this.visPlaceService.getItemById(placeId);
        }
        Map dataMap = this.visPlaceService.getVisDefaultData(item);
        dataMap.putAll(paramMap);
        if (item != null && StringUtils.isNotBlank((CharSequence)item.getIPCId()) && !this.visPlaceService.checkIPC(item.getIPCId()).booleanValue()) {
            dataMap.put("checkIPC", "0");
        } else {
            dataMap.put("checkIPC", "1");
        }
        return new ZKResultMsg((Object)dataMap);
    }

    public ZKResultMsg detectNotShow(@RequestParam(value="placeId") String placeId) {
        VisPlaceItem item = this.visPlaceService.getItemById(placeId);
        item.setShowDetect(Short.valueOf((short)0));
        this.visPlaceService.saveDetectShow(item);
        return new ZKResultMsg();
    }

    public ZKResultMsg detectShow(@RequestParam(value="placeId") String placeId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", (Object)"none");
        VisPlaceItem item = this.visPlaceService.getItemById(placeId);
        if (item != null && 1 != item.getShowDetect()) {
            jsonObject.put("state", (Object)"merge");
            item.setShowDetect(Short.valueOf((short)1));
            this.visPlaceService.saveDetectShow(item);
        }
        return new ZKResultMsg((Object)jsonObject);
    }

    public Map<String, Object> getVidCapture() {
        String channelId = this.request.getParameter("channelId");
        if (StringUtils.isNotBlank((CharSequence)channelId)) {
            return this.visPlaceService.getVidCapture(channelId);
        }
        return null;
    }

    public String validPhysicalKey(@RequestParam(value="physicalKey") String physicalKey) {
        VisPlaceItem item = this.visPlaceService.getItemByPhysicalKey(physicalKey);
        boolean rs = item == null;
        return rs + "";
    }

    public TreeItem getPlaceTree() {
        List visPlaceItems = this.visPlaceService.getByCondition(new VisPlaceItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = new TreeItem("0");
        for (VisPlaceItem visPlaceItem : visPlaceItems) {
            item = new TreeItem();
            item.setId(visPlaceItem.getId());
            item.setText(visPlaceItem.getName());
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ZKResultMsg getVidItemByChannelId(String channelId) {
        return this.visPlaceService.getVidItemByChannelId(channelId);
    }
}

