/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.vis.remote.VisAutoReservationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisReasonService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitedPersonService;
import com.zkteco.zkbiosecurity.vis.vo.VisAutoReservationItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReasonItem;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAutoReservationController
extends BaseController
implements VisAutoReservationRemote {
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisReasonService visReasonService;
    @Autowired
    private VisReservationService visReservationService;
    @Autowired
    private VisVisitedPersonService visVisitedPersonService;
    @Value(value="${system.language}")
    private String sysLanguage;

    public ZKResultMsg visAutoRes(@RequestBody VisAutoReservationItem item) {
        return this.visReservationService.saveVisReservationFromH5(item);
    }

    public ModelAndView autoReservationView(VisAutoReservationItem item) {
        String enableHealthInfo = this.visParamsService.getVisParamByName("vis.enableHealthInfo");
        if ("1".equals(enableHealthInfo) && (item == null || StringUtils.isEmpty((CharSequence)item.getExposure()) && StringUtils.isEmpty((CharSequence)item.getSymptom()) && StringUtils.isEmpty((CharSequence)item.getTemperature()))) {
            ModelAndView mv = new ModelAndView("vis/autoReservation/visVisitorHealth");
            mv.addObject("language", (Object)this.sysLanguage);
            return mv;
        }
        String requiredVisitedEmp = this.visParamsService.getVisParamByName("vis.requiredVisitedEmp");
        List visReasonItemList = this.visReasonService.getByCondition(new VisReasonItem());
        StringBuffer visReason = new StringBuffer();
        visReasonItemList.forEach(v -> visReason.append(v.getName()).append(","));
        List certificateTypeList = this.visReservationService.selectList("certificateType");
        ModelAndView mv = new ModelAndView("vis/autoReservation/visVisitorReg");
        mv.addObject("language", (Object)this.sysLanguage);
        mv.addObject("enableHealthInfo", (Object)enableHealthInfo);
        mv.addObject("visReason", (Object)visReason.deleteCharAt(visReason.length() - 1));
        mv.addObject("certType", (Object)certificateTypeList);
        mv.addObject("requiredVisitedEmp", (Object)requiredVisitedEmp);
        mv.addObject("temperature", (Object)item.getTemperature());
        mv.addObject("exposure", (Object)item.getExposure());
        mv.addObject("symptom", (Object)item.getSymptom());
        mv.addObject("visitCity", (Object)item.getVisitCity());
        mv.addObject("healthRemarks", (Object)item.getHealthRemarks());
        return mv;
    }

    public ZKResultMsg getVisitedName(String name) {
        List items = this.visVisitedPersonService.getPersonListByName(name);
        if (CollectionUtils.isEmpty((Collection)items)) {
            return ZKResultMsg.failMsg();
        }
        return new ZKResultMsg((Object)items);
    }

    public ModelAndView endReservation() {
        return new ModelAndView("vis/autoReservation/visSuccessReg");
    }
}

