/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitorRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisTransactionService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListCategoryService;
import com.zkteco.zkbiosecurity.vis.service.VisWatchListService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorItem;
import com.zkteco.zkbiosecurity.vis.vo.VisWatchListItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisVisitorController
extends ExportController
implements VisVisitorRemote {
    @Autowired
    private VisVisitorService visVisitorService;
    @Autowired
    private VisTransactionService visTransactionService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisWatchListService visWatchListService;
    @Autowired
    private VisWatchListCategoryService visWatchListCategoryService;

    @RequiresPermissions(value={"vis:visitor"})
    public ModelAndView index() {
        return new ModelAndView("vis/visitor/visVisitor");
    }

    @RequiresPermissions(value={"vis:visitor:refresh"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            VisVisitorItem visitorItem = this.visVisitorService.getItemById(id);
            visitorItem.setCertName(I18nUtil.i18nCode((String)this.visVisitorService.getCertNameByCertCode(visitorItem.getCertType()), (Object[])new Object[0]));
            this.request.setAttribute("item", (Object)visitorItem);
            List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
            this.getAttribute(attributes);
            Map valueMap = this.visVisitorService.getVisitorAttributeValues(id);
            this.request.setAttribute("map1", (Object)valueMap);
            if (this.visWatchListService.checkLicense()) {
                VisWatchListItem visWatchListItem = this.visWatchListService.findByCerTypeAndCerNum(visitorItem.getCertType(), visitorItem.getCertNumber());
                if (Objects.nonNull(visWatchListItem)) {
                    String categoryName = this.visWatchListCategoryService.findByID(visWatchListItem.getCategory());
                    categoryName = StringUtils.isBlank((CharSequence)categoryName) ? I18nUtil.i18nCode((String)"vis_watchList_normal", (Object[])new Object[0]) : categoryName;
                    visWatchListItem.setCategory(categoryName);
                } else {
                    visWatchListItem = new VisWatchListItem();
                    visWatchListItem.setCategory(I18nUtil.i18nCode((String)"vis_watchList_normal", (Object[])new Object[0]));
                }
                this.request.setAttribute("watchList", (Object)visWatchListItem);
            }
        }
        return new ModelAndView("vis/visitor/editVisVisitor");
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    @RequiresPermissions(value={"vis:visitor:refresh"})
    public ZKResultMsg save(VisVisitorItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visVisitorService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:visitor:refresh"})
    public DxGrid list(VisVisitorItem condition) {
        Pager pager = this.visVisitorService.getItemsAndAttrByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        if (!this.visWatchListService.checkLicense()) {
            pager.getData().forEach(item -> {
                VisVisitorItem vo = (VisVisitorItem)item;
                vo.setStatus("-");
            });
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:visitor:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_empinfo", opType="common_op_del", requestParams={"names"}, opContent="pers_person_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        String visEmpPin = this.visVisitorService.delVisitor(ids);
        ZKResultMsg zkResultMsg = new ZKResultMsg("ok", I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]));
        if (StringUtils.isNotBlank((CharSequence)visEmpPin)) {
            visEmpPin = visEmpPin.substring(0, visEmpPin.length() - 1);
            zkResultMsg.setRet("500");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_cannotDeleteVis", (Object[])new Object[]{visEmpPin}));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_empinfo", opType="vis_emp_disable", requestParams={"names", "certNumbers"}, opContent="pers_person_name")
    public ZKResultMsg addBlackList(@RequestParam(value="ids") String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg("ok", I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]));
        List idList = StrUtil.strToList((String)ids);
        int count = this.visVisitorService.addBlackList(idList);
        if (count != 0 && idList.size() == 1) {
            zkResultMsg.setRet("500");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_addBlackRepeat", (Object[])new Object[0]));
        }
        if (count != 0 && idList.size() > 1) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_addBlackExistRepeat", (Object[])new Object[0]));
        }
        return zkResultMsg;
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_empinfo", opType="vis_emp_enable", requestParams={"names", "certNumbers"}, opContent="pers_person_name")
    public ZKResultMsg removeBlackList(@RequestParam(value="ids") String ids) {
        ZKResultMsg zkResultMsg = new ZKResultMsg("ok", I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0]));
        List idList = StrUtil.strToList((String)ids);
        int count = this.visVisitorService.removeBlackList(idList);
        if (count != 0 && idList.size() == 1) {
            zkResultMsg.setRet("500");
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_notRemoveBlack", (Object[])new Object[0]));
        }
        if (count != 0 && idList.size() > 1) {
            zkResultMsg.setMsg(I18nUtil.i18nCode((String)"vis_message_existNotRemoveBlack", (Object[])new Object[0]));
        }
        return zkResultMsg;
    }

    public void export(HttpServletRequest request, HttpServletResponse response) {
        VisVisitorItem visVisitorItem = new VisVisitorItem();
        this.setConditionValue((BaseItem)visVisitorItem);
        List itemList = this.visVisitorService.getVisitorItemData(VisVisitorItem.class, (BaseItem)visVisitorItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, VisVisitorItem.class);
    }

    public void getVisitorInfoById(String id) {
        this.response.setContentType("text/xml;charset=utf-8");
        this.response.setHeader("Cache-Control", "no-cache");
        VisVisitorItem visitorItem = this.visVisitorService.getItemById(id);
        if (visitorItem != null) {
            ArrayList<VisVisitorItem> visVisitorItemList = new ArrayList<VisVisitorItem>();
            visVisitorItemList.add(visitorItem);
            this.writerVisitor(visVisitorItemList);
        }
    }

    private void writerVisitor(List<VisVisitorItem> visVisitorItemList) {
        try {
            StringBuffer result = new StringBuffer();
            result.append("<complete>");
            for (VisVisitorItem visitorItem : visVisitorItemList) {
                result.append("<option value=\"" + visitorItem.getId() + "\">");
                result.append("<text>");
                result.append("<pin>");
                result.append(visitorItem.getPin());
                result.append("</pin>");
                result.append("<name>");
                result.append(visitorItem.getName());
                result.append("</name>");
                result.append("<lastName>");
                result.append((String)StringUtils.defaultIfEmpty((CharSequence)visitorItem.getLastName(), (CharSequence)""));
                result.append("</lastName>");
                result.append("<certTypeCode>");
                result.append(visitorItem.getCertType());
                result.append("</certTypeCode>");
                result.append("<certType>");
                result.append(I18nUtil.i18nCode((String)this.visVisitorService.getCertNameByCertCode(visitorItem.getCertType()), (Object[])new Object[0]));
                result.append("</certType>");
                result.append("<certNumber>");
                result.append(visitorItem.getCertNumber());
                result.append("</certNumber>");
                result.append("<company>");
                result.append((String)StringUtils.defaultIfEmpty((CharSequence)visitorItem.getCompany(), (CharSequence)""));
                result.append("</company>");
                result.append("<phone>");
                result.append((String)StringUtils.defaultIfEmpty((CharSequence)visitorItem.getPhone(), (CharSequence)""));
                result.append("</phone>");
                result.append("</text>");
                result.append("</option>");
            }
            result.append("</complete>");
            this.response.getWriter().write(result.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void searchName() {
        try {
            this.response.setContentType("text/xml;charset=utf-8");
            this.response.setHeader("Cache-Control", "no-cache");
            String mask = this.request.getParameter("mask");
            if (StringUtils.isBlank((CharSequence)mask)) {
                this.response.getWriter().write("<complete></complete>");
                return;
            }
            String pos = this.request.getParameter("pos");
            List visVisitorItemList = this.visVisitorService.getByNameSpell(mask, pos);
            this.writerVisitor(visVisitorItemList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void getTodayVisitor() {
        this.response.setContentType("text/xml;charset=utf-8");
        this.response.setHeader("Cache-Control", "no-cache");
        List visVisitorItemList = this.visVisitorService.getTodayVisitor();
        this.writerVisitor(visVisitorItemList);
    }

    public void searchNameNotExit() {
        try {
            this.response.setContentType("text/xml;charset=utf-8");
            this.response.setHeader("Cache-Control", "no-cache");
            String mask = this.request.getParameter("mask");
            if (StringUtils.isBlank((CharSequence)mask)) {
                this.response.getWriter().write("<complete></complete>");
                return;
            }
            String pos = this.request.getParameter("pos");
            List ids = this.visTransactionService.getNotExitVisitor();
            List visVisitorItemList = this.visVisitorService.getByNameSpellAndIds(mask, pos, ids);
            this.writerVisitor(visVisitorItemList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

