/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.constants.VisConstants;
import com.zkteco.zkbiosecurity.vis.remote.VisReservationRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.service.VisParamsService;
import com.zkteco.zkbiosecurity.vis.service.VisReservationService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import com.zkteco.zkbiosecurity.vis.vo.VisReservationItem;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.Transformer;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisReservationController
extends BaseController
implements VisReservationRemote {
    @Autowired
    private VisReservationService visReservationService;
    @Autowired
    private VisParamsService visParamsService;
    @Autowired
    private VisAttributeService visAttributeService;
    @Autowired
    private VisVisitorService visVisitorService;

    @RequiresPermissions(value={"vis:reservation"})
    public ModelAndView index() {
        return new ModelAndView("vis/reservation/visReservation");
    }

    @RequiresPermissions(value={"vis:reservation:edit", "vis:reservation:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        Map visParams = this.visParamsService.getVisParams();
        this.request.setAttribute("visParams", (Object)visParams);
        try {
            if (StringUtils.isNotBlank((CharSequence)id)) {
                VisReservationItem item = this.visReservationService.getItemById(id);
                boolean isExpired = false;
                Calendar calendar = Calendar.getInstance();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                calendar.setTimeInMillis(sdf.parse(item.getVisitDate()).getTime());
                int visitDate = calendar.get(6);
                calendar.setTimeInMillis(System.currentTimeMillis());
                int today = calendar.get(6);
                isExpired = StringUtils.equals((CharSequence)item.getIsVisited(), (CharSequence)"2") || StringUtils.equals((CharSequence)item.getIsVisited(), (CharSequence)"0") || VisConstants.RESERVATION_AUDIT.equals(item.getAuditStatus()) || visitDate < today;
                this.request.setAttribute("isExpired", (Object)String.valueOf(isExpired));
                this.request.setAttribute("item", (Object)item);
                Map valueMap = this.visVisitorService.getVisitorAttributeValues(item.getVisitorId());
                this.request.setAttribute("map1", (Object)valueMap);
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        List attributes = this.visAttributeService.getByCondition(new VisAttributeItem());
        this.getAttribute(attributes);
        return new ModelAndView("vis/reservation/editVisReservation");
    }

    private void getAttribute(List<VisAttributeItem> attributeItems) {
        ArrayList rows = new ArrayList();
        ArrayList<Integer> rowInts = new ArrayList<Integer>();
        HashMap<String, ArrayList<Integer>> maxTds = new HashMap<String, ArrayList<Integer>>();
        HashMap<String, VisAttributeItem> attrs = new HashMap<String, VisAttributeItem>();
        for (VisAttributeItem attributeItem : attributeItems) {
            ArrayList<Integer> colList;
            Integer row = attributeItem.getPositionX();
            Integer col = attributeItem.getPositionY();
            if (!rowInts.contains(row)) {
                rowInts.add(row);
            }
            if ((colList = (ArrayList<Integer>)maxTds.get("" + row)) == null) {
                colList = new ArrayList<Integer>();
            }
            colList.add(col);
            Collections.sort(colList);
            maxTds.put("" + row, colList);
            attrs.put("" + row + col, attributeItem);
        }
        Collections.sort(rowInts);
        CollectionUtils.collect(rowInts, (Transformer)new Transformer(){

            public Object transform(Object o) {
                return o.toString();
            }
        }, rows);
        this.request.setAttribute("attrs", attrs);
        this.request.setAttribute("tds", maxTds);
        this.request.setAttribute("trs", rows);
    }

    @RequiresPermissions(value={"vis:reservation:edit", "vis:reservation:add"})
    @LogRequest(module="vis_module", object="vis_leftMenu_reservation", opType="common_op_edit", requestParams={"visitorName"}, opContent="pers_person_name")
    public ZKResultMsg save(VisReservationItem item, @RequestParam Map<String, String> attrMap) {
        ZKResultMsg res = new ZKResultMsg();
        item.setAttrMap(attrMap);
        this.visReservationService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:reservation:refresh"})
    public DxGrid list(VisReservationItem condition) {
        Pager pager = this.visReservationService.getItemsAndAttrByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:reservation:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_reservation", opType="common_op_del", requestParams={"visitorNames", "visitEmpNames"}, opContent="pers_person_name")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visReservationService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg loadVisInfo() {
        String certNumber = this.request.getParameter("certNumber");
        String certType = this.request.getParameter("certType");
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        if (StringUtils.isBlank((CharSequence)certType)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"vis_message_certTypeRequired", (Object[])new Object[0]));
        }
        if (StringUtils.isBlank((CharSequence)certNumber)) {
            throw new ZKBusinessException(I18nUtil.i18nCode((String)"vis_message_certNumberRequired", (Object[])new Object[0]));
        }
        zkResultMsg = this.visReservationService.loadVisInfo(certType, certNumber);
        return zkResultMsg;
    }
}

