/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.api.controller;

import com.zkteco.zkbiosecurity.base.annotation.ApiPermissions;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.vis.service.VisLevelService;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisLevelItem;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorLevelItem;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/visLevel"})
public class VisCloudApiLevelController {
    private static final Logger log = LoggerFactory.getLogger(VisCloudApiLevelController.class);
    @Autowired
    private VisLevelService visLevelService;
    @Autowired
    private VisVisitorLevelService visVisitorLevelService;

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getLevelPager"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLevelPager(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = new ZKResultMsg();
        try {
            String levelName = MapUtils.getString((Map)zkMessage.getContent(), (Object)"levelName");
            int page = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"page");
            int pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
            Pager pager = this.visLevelService.getLevelPager(levelName, page, pageSize);
            rs.setData((Object)pager);
            return I18nUtil.i18nMsg((ZKResultMsg)rs);
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisitorLevelPager"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getVisitorLevelPager(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = new ZKResultMsg();
        try {
            String filter = MapUtils.getString((Map)zkMessage.getContent(), (Object)"filter");
            String levelId = MapUtils.getString((Map)zkMessage.getContent(), (Object)"levelId");
            int page = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"page");
            int pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
            VisVisitorLevelItem visVisitorLevelItem = new VisVisitorLevelItem();
            if (StringUtils.isNotBlank((CharSequence)levelId)) {
                visVisitorLevelItem.setLevelId(levelId);
            }
            visVisitorLevelItem.setFilter(filter);
            Pager pager = this.visVisitorLevelService.getVisitorLevelPager(visVisitorLevelItem, page, pageSize);
            rs.setData((Object)pager);
            return I18nUtil.i18nMsg((ZKResultMsg)rs);
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/getVisAccOrEleLevelPager"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getVisAccOrEleLevelPager(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = new ZKResultMsg();
        try {
            String leveName = MapUtils.getString((Map)zkMessage.getContent(), (Object)"leveName");
            String areaCodes = MapUtils.getString((Map)zkMessage.getContent(), (Object)"areaCodes");
            String moduleName = MapUtils.getString((Map)zkMessage.getContent(), (Object)"moduleName");
            int page = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"page");
            int pageSize = MapUtils.getInteger((Map)zkMessage.getContent(), (Object)"pageSize");
            if ("acc".equals(moduleName)) {
                Pager pager = this.visLevelService.getVisAccLevelPager(leveName, areaCodes, page, pageSize);
                rs.setData((Object)pager);
            } else if ("ele".equals(moduleName)) {
                Pager pager = this.visLevelService.getVisEleLevelPager(leveName, areaCodes, page, pageSize);
                rs.setData((Object)pager);
            }
            return I18nUtil.i18nMsg((ZKResultMsg)rs);
        }
        catch (Exception e) {
            return ZKResultMsg.getFailMsg((String)e.getMessage());
        }
    }

    @ApiPermissions(moduleCode="vis", moduleName="vis_module")
    @ResponseBody
    @RequestMapping(value={"/saveVisLevel"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg saveVisLevel(@RequestBody ZKMessage zkMessage) {
        ZKResultMsg rs = new ZKResultMsg();
        try {
            String levelIds = MapUtils.getString((Map)zkMessage.getContent(), (Object)"levelIds");
            String levelNames = MapUtils.getString((Map)zkMessage.getContent(), (Object)"levelNames");
            String moduleName = MapUtils.getString((Map)zkMessage.getContent(), (Object)"moduleName");
            String[] levelIdArray = levelIds.split(",");
            String[] levelNameArray = levelNames.split(",");
            for (int i = 0; i < levelIdArray.length; ++i) {
                VisLevelItem visLevelItem = new VisLevelItem();
                visLevelItem.setLevelModule(moduleName);
                visLevelItem.setModuleId(levelIdArray[i]);
                visLevelItem.setLevelName(levelNameArray[i]);
                this.visLevelService.saveItem(visLevelItem);
            }
            return I18nUtil.i18nMsg((ZKResultMsg)rs);
        }
        catch (Exception e) {
            log.error("api visLevel/saveVisLevel error ", (Throwable)e);
            rs = ZKResultMsg.failMsg();
            return I18nUtil.i18nMsg((ZKResultMsg)rs);
        }
    }
}

