/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.client.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.CollectionUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseClientService;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import com.zkteco.zkbiosecurity.message.bean.ZKMessage;
import com.zkteco.zkbiosecurity.pers.client.utils.PersUploadPageUtil;
import com.zkteco.zkbiosecurity.pers.service.PersLeavePersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersPositionService;
import com.zkteco.zkbiosecurity.pers.service.PersTempPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersLeavePersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonCloudItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPositionItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTempPersonItem;
import com.zkteco.zkbiosecurity.system.app.service.BaseAuthCloudMessageSendService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.service.SystemPersInfo2CloudService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class PersMessageUpload {
    private static final Logger logger = LoggerFactory.getLogger(PersMessageUpload.class);
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersTempPersonService persTempPersonService;
    @Autowired
    private BaseLicenseService baseLicenseService;
    @Autowired
    private BaseLicenseClientService baseLicenseClientService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseAuthCloudMessageSendService baseAuthCloudMessageSendService;
    @Autowired
    private PersLeavePersonService persLeavePersonService;
    @Autowired
    private PersPositionService persPositionService;
    @Autowired
    private SystemPersInfo2CloudService pers2CloudService;

    @Async
    @Scheduled(cron="0 0/5 * * * ?")
    public ZKResultMsg persMessageUpload() {
        boolean isUploadBasic = this.baseSysParamService.getAlreadyInitModule("BasicData");
        if (StringUtils.isNotBlank((CharSequence)this.baseLicenseService.getAppId()) && isUploadBasic) {
            Long pushTime = this.pers2CloudService.getPersonLastPushTime();
            ZKMessage zkMessage = new ZKMessage();
            zkMessage.setModuleCode("pers");
            zkMessage.setMessageId("persCloudHandleMessage#personMessageHandle");
            zkMessage.setAppId(this.baseLicenseService.getAppId());
            if (pushTime == null) {
                this.baseAuthCloudMessageSendService.syncAllDepartmentToCloud();
                Long personCount = this.persPersonService.getPersonCount();
                int pageNo = PersUploadPageUtil.getPage(personCount);
                for (int i = 0; i < pageNo; ++i) {
                    List persPersonItemList = this.persPersonService.getPersonCloudItems(new PersPersonCloudItem().setIsFromNotIn("PERS_USER_LEAVE_ADDED"), i, 30);
                    zkMessage.setListContent(persPersonItemList);
                    this.baseLicenseClientService.sendMessage(zkMessage);
                }
            } else {
                Date lastUpdate = new Date(pushTime);
                List persPersonCloudItemList = this.persPersonService.getUpdatePersonItem(lastUpdate = DateUtil.addMinute((Date)lastUpdate, (int)-1));
                if (persPersonCloudItemList != null && !persPersonCloudItemList.isEmpty()) {
                    List persCloudPersons = CollectionUtil.split((Collection)persPersonCloudItemList, (int)30);
                    for (List persPersonCloudItems : persCloudPersons) {
                        zkMessage.setListContent(persPersonCloudItems);
                        this.baseLicenseClientService.sendMessage(zkMessage);
                    }
                }
            }
            this.pers2CloudService.setPersonLastPushTime();
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg issuePersonMessage(ZKMessage zkMessage) {
        List personMessageList = zkMessage.getListContent();
        if (personMessageList != null && personMessageList.size() > 0) {
            List persTempPersonItems = JSONArray.parseArray((String)personMessageList.toString(), PersTempPersonItem.class);
            persTempPersonItems.forEach(persTempPersonItem -> {
                try {
                    this.persTempPersonService.savePersonRegistrar(persTempPersonItem);
                }
                catch (Exception e) {
                    logger.error("persCloud issuePersonMessage error: ", (Throwable)e);
                }
            });
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg updatePersonPassword(ZKMessage zkMessage) {
        Map dataMap = zkMessage.getContent();
        if (dataMap != null && dataMap.size() > 0) {
            PersPersonItem persPersonItem;
            String password;
            String pin = dataMap.containsKey("pin") ? (String)dataMap.get("pin") : null;
            String string = password = dataMap.containsKey("password") ? (String)dataMap.get("password") : null;
            if (StringUtils.isNotBlank((CharSequence)pin) && StringUtils.isNotBlank((CharSequence)password) && (persPersonItem = this.persPersonService.getItemByPin(pin)) != null) {
                this.persPersonService.updateSelfPwd(persPersonItem.getId(), password);
            }
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg syncPersonFromCloud(ZKMessage zkMessage) {
        List personMessageList = zkMessage.getListContent();
        if (personMessageList != null && personMessageList.size() > 0) {
            List persTempPersonItems = JSONArray.parseArray((String)personMessageList.toString(), PersTempPersonItem.class);
            this.persTempPersonService.syncPersonFromCloud(persTempPersonItems);
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg delPersonByPin(ZKMessage zkMessage) {
        List persPersonItemList;
        String persIds;
        List pinList = zkMessage.getListContent();
        if (pinList != null && pinList.size() > 0 && !"-1".equals(persIds = CollectionUtil.getPropertys((Collection)(persPersonItemList = this.persPersonService.getItemsByPins((Collection)pinList)), PersPersonItem::getId))) {
            this.persPersonService.deleteByIds(persIds);
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg leavePersonByPin(ZKMessage zkMessage) {
        List pinList = zkMessage.getListContent();
        if (pinList != null && pinList.size() > 0) {
            List persPersonItemList = this.persPersonService.getItemsByPins((Collection)pinList);
            String persIds = CollectionUtil.getPropertys((Collection)persPersonItemList, PersPersonItem::getId);
            PersLeavePersonItem persLeavePersonItem = new PersLeavePersonItem();
            persLeavePersonItem.setLeaveDate(new Date());
            persLeavePersonItem.setLeaveType(Integer.valueOf(1));
            if (!"-1".equals(persIds)) {
                this.persLeavePersonService.batchLeave(persLeavePersonItem, persIds);
            }
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg delPersPositionByCode(ZKMessage zkMessage) {
        List persPositionItemList;
        String positionIds;
        List codeList = zkMessage.getListContent();
        if (codeList != null && codeList.size() > 0 && !"-1".equals(positionIds = CollectionUtil.getPropertys((Collection)(persPositionItemList = this.persPositionService.getItemsByCodes((Collection)codeList)), PersPositionItem::getId))) {
            this.persPositionService.deleteByIds(positionIds);
        }
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg updatePersPosition(ZKMessage zkMessage) {
        List positionList = zkMessage.getListContent();
        if (positionList != null && positionList.size() > 0) {
            List persPositionItems = JSONArray.parseArray((String)positionList.toString(), PersPositionItem.class);
            this.persPositionService.updatePersPositionItem(persPositionItems);
        }
        return ZKResultMsg.successMsg();
    }
}

