/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.remote.InsPersonRemote;
import com.zkteco.zkbiosecurity.ins.service.InsAreaPersonService;
import com.zkteco.zkbiosecurity.ins.service.InsPersonService;
import com.zkteco.zkbiosecurity.ins.vo.InsPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsPersonController
extends BaseController
implements InsPersonRemote {
    @Autowired
    private InsPersonService insPersonService;
    @Autowired
    private InsAreaPersonService insAreaPersonService;

    @RequiresPermissions(value={"ins:person:view"})
    public ModelAndView index() {
        return new ModelAndView("ins/person/insPerson");
    }

    @RequiresPermissions(value={"ins:person:edit", "pers:person:insEdit"})
    public ModelAndView edit(@RequestParam(value="personId", required=false) String personId) {
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            InsPersonItem insPersonItem = this.insPersonService.getItemByPersonId(personId);
            if (Objects.isNull(insPersonItem)) {
                insPersonItem = new InsPersonItem();
            }
            this.request.setAttribute("item", (Object)insPersonItem);
            this.request.setAttribute("insPersonAreas", (Object)this.insAreaPersonService.getAreaIdsByPersonId(personId));
        } else {
            this.request.setAttribute("insPersonAreas", (Object)this.insAreaPersonService.getRootAreaId());
        }
        return new ModelAndView("ins/person/editInsPerson");
    }

    @RequiresPermissions(value={"ins:person:edit"})
    public ZKResultMsg save(InsPersonItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.insPersonService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:person:refresh"})
    public DxGrid list(InsPersonItem condition) {
        Pager pager = this.insPersonService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"ins:person:del"})
    @LogRequest(module="ins_module", object="ins_leftMenu_person", opType="common_op_del", requestParams={"ids"}, opContent="ins_common_id")
    public ZKResultMsg delete(String ids) {
        this.insPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

