/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.ins.remote.InsDeviceOptionRemote;
import com.zkteco.zkbiosecurity.ins.service.InsDeviceOptionService;
import com.zkteco.zkbiosecurity.ins.vo.InsDeviceOptionItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class InsDeviceOptionController
extends BaseController
implements InsDeviceOptionRemote {
    @Autowired
    private InsDeviceOptionService insDeviceOptionService;

    @RequiresPermissions(value={"ins:deviceoption"})
    public ModelAndView index() {
        return new ModelAndView("ins/deviceoption/insDeviceOption");
    }

    @RequiresPermissions(value={"ins:deviceoption:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.insDeviceOptionService.getItemById(id));
        }
        return new ModelAndView("ins/deviceoption/editInsDeviceOption");
    }

    @RequiresPermissions(value={"ins:deviceoption:edit"})
    public ZKResultMsg save(InsDeviceOptionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.insDeviceOptionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"ins:deviceoption:refresh"})
    public DxGrid list(InsDeviceOptionItem codition) {
        Pager pager = this.insDeviceOptionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"ins:deviceoption:del"})
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.insDeviceOptionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }
}

