/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.biz;

import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.core.utils.HttpUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LicModule;
import com.zkteco.zkbiosecurity.guard.license.util.LicFileHelper;
import com.zkteco.zkbiosecurity.license.vo.IModuleAuth;
import com.zkteco.zkbiosecurity.license.vo.LicenseCheckInnerInvoke;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class LicenseCheckBiz {
    private static final Logger logger = LoggerFactory.getLogger(LicenseCheckBiz.class);
    @Autowired(required=false)
    private IModuleAuth[] moduleAuths;
    @Autowired(required=false)
    private LicenseCheckInnerInvoke[] licenseCheckInnerInvoke;
    @Value(value="${licenseCheckLicenseUrl}")
    private String licenseCheckLicenseUrl;

    @Scheduled(cron="0 0 0/2 * * ?")
    public void check() {
        logger.info("start license check-------------");
        List<LicModule> modules = LicFileHelper.readLicModules(LicFileHelper.getLicPath());
        if (modules != null && !modules.isEmpty()) {
            for (LicModule module : modules) {
                if (StringUtils.isBlank((CharSequence)module.getLicenseNumber()) || this.checkLicenseNumber(module.getLicenseNumber())) continue;
                logger.info(String.format("check licenseNumber:%s  failed", module.getLicenseNumber()));
                logger.info("expired license...");
                LicenseUtil.expiredLicense();
                LicenseUtil.licenseCheckExpired(this.licenseCheckInnerInvoke);
                logger.info("clean license info...");
                LicFileHelper.cleanLicCompanyAndLicense();
                logger.info("reload license");
                LicenseUtil.reloadLicense(this.moduleAuths);
                break;
            }
        }
    }

    private boolean checkLicenseNumber(String licenseNumber) {
        ConcurrentMap params = Maps.newConcurrentMap();
        params.put("license", licenseNumber);
        try {
            String rsp = HttpUtil.post((String)this.licenseCheckLicenseUrl, (Map)params);
            if (StringUtils.equalsIgnoreCase((CharSequence)rsp, (CharSequence)"false")) {
                return false;
            }
            logger.debug(String.format("check licenseNumber:%s ol success", licenseNumber));
        }
        catch (Exception e) {
            logger.info("check licenseNumber Exception");
        }
        return true;
    }
}

