/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.zkteco.zkbiosecurity.auth.remote.MainRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.service.AuthSessionServcie;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.bean.ParentMenu;
import com.zkteco.zkbiosecurity.base.bean.SubMenu;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.WebContextUtil;
import com.zkteco.zkbiosecurity.license.service.BaseLicenseService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.WebUtils;

@Controller
public class MainController
extends BaseController
implements MainRemote {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private AuthSessionServcie authSessionServcie;
    @Autowired(required=false)
    private BaseLicenseService baseLicenseService;
    @Value(value="${system.menuType:}")
    private String menuType;
    @Value(value="${system.isCloud:false}")
    private Boolean isCloud;
    @Value(value="${system.menuOrder:}")
    private String systemMenuOrder;
    @Resource
    private RedisTemplate redisTemplate;

    private void sortMenuOrder(List<AuthPermissionItem> hasSystemMenus) {
        if (StringUtils.isNotBlank((CharSequence)this.systemMenuOrder)) {
            final List<String> menuOrderList = Arrays.asList(this.systemMenuOrder.toLowerCase().split(","));
            hasSystemMenus.sort(new Comparator<AuthPermissionItem>(){

                @Override
                public int compare(AuthPermissionItem menu0, AuthPermissionItem menu1) {
                    int ind0 = menuOrderList.indexOf(menu0.getCode().toLowerCase());
                    int ind1 = menuOrderList.indexOf(menu1.getCode().toLowerCase());
                    if (ind0 == -1 && ind1 == -1) {
                        return menu0.getOrderNo() - menu1.getOrderNo() >= 0 ? 1 : -1;
                    }
                    if (ind0 != -1 && ind1 != -1) {
                        return ind0 - ind1 >= 0 ? 1 : -1;
                    }
                    if (ind0 != -1) {
                        return -1;
                    }
                    if (ind1 != -1) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
    }

    public ModelAndView home() {
        List systemMenus = this.authPermissionService.getSystemMenus();
        List<Object> hasSystemMenus = new ArrayList<AuthPermissionItem>();
        for (AuthPermissionItem authPermissionItem : systemMenus) {
            if (!this.authPermissionService.checkPermission(this.request.getSession().getId(), authPermissionItem.getPermission())) continue;
            authPermissionItem.setName(I18nUtil.i18nCode((String)authPermissionItem.getName(), (Object[])new Object[0]));
            hasSystemMenus.add(authPermissionItem);
        }
        if (this.baseLicenseService != null) {
            hasSystemMenus = hasSystemMenus.stream().filter(m -> this.baseLicenseService.getLicenseModules().contains(m.getCode().toLowerCase())).collect(Collectors.toList());
        }
        this.sortMenuOrder(hasSystemMenus);
        this.request.getSession().setAttribute("systemMenus", hasSystemMenus);
        this.setMenuTypeToSession(this.request);
        this.request.getSession().setAttribute("image_header_about", (Object)(this.isCloud != false ? "hidden" : null));
        this.request.getSession().setAttribute("isCloud", (Object)this.isCloud);
        return new ModelAndView("public/html/home");
    }

    private void setMenuTypeToSession(HttpServletRequest request) {
        Cookie cookie;
        String type = request.getParameter("menuType");
        String _menuType = null;
        if (StringUtils.isNotBlank((CharSequence)type)) {
            if ("1".equals(type)) {
                _menuType = "text-only";
            } else if ("2".equals(type)) {
                _menuType = "icon-only";
            } else if ("3".equals(type)) {
                _menuType = "icon-text";
            }
        }
        if (StringUtils.isBlank(_menuType) && (cookie = WebUtils.getCookie((HttpServletRequest)request, (String)"menuType")) != null) {
            _menuType = cookie.getValue();
        }
        if (StringUtils.isBlank(_menuType)) {
            _menuType = (String)request.getSession().getAttribute("menuType");
        }
        request.getSession().setAttribute("menuType", (Object)(StringUtils.isBlank((CharSequence)_menuType) ? this.menuType : _menuType));
    }

    public List<ParentMenu> getLeftMenu(String systemCode) {
        ArrayList<ParentMenu> menus = new ArrayList<ParentMenu>();
        List authPermissionItems = this.authPermissionService.getAuthPermissionBySystemCode(systemCode);
        ParentMenu parentMenu = null;
        SubMenu subMenu = null;
        List subPermissionItems = null;
        Map licenseMenuMap = this.authPermissionService.getLicenseMenuMap(this.request.getSession().getId());
        for (AuthPermissionItem item : authPermissionItems) {
            if (!this.authPermissionService.checkPermission(this.request.getSession().getId(), item.getPermission()) || licenseMenuMap.containsKey(item.getPermission()) && (!licenseMenuMap.containsKey(item.getPermission()) || !((Boolean)licenseMenuMap.get(item.getPermission())).booleanValue())) continue;
            parentMenu = new ParentMenu(item.getId(), I18nUtil.i18nCode((String)item.getName(), (Object[])new Object[0]), item.getImg(), item.getImgHover());
            subMenu = new SubMenu("0");
            subPermissionItems = this.authPermissionService.getAuthPermissionByParentId(item.getId());
            for (AuthPermissionItem authPermissionItem : subPermissionItems) {
                if (!this.authPermissionService.checkPermission(this.request.getSession().getId(), authPermissionItem.getPermission()) || licenseMenuMap.containsKey(authPermissionItem.getPermission()) && (!licenseMenuMap.containsKey(authPermissionItem.getPermission()) || !((Boolean)licenseMenuMap.get(authPermissionItem.getPermission())).booleanValue())) continue;
                subMenu.getItem().add(new SubMenu(authPermissionItem.getActionLink(), I18nUtil.i18nCode((String)authPermissionItem.getName(), (Object[])new Object[0])));
            }
            parentMenu.setItem(subMenu);
            menus.add(parentMenu);
        }
        return menus;
    }

    public ZKResultMsg isNeedValidUser(String mode) {
        Object value;
        String id = WebContextUtil.getCurrentSessionId();
        String key = "valid_" + id;
        if (StringUtils.isNotBlank((CharSequence)mode) && mode.indexOf(":") != -1) {
            key = "valid_" + mode.split(":")[0].trim() + id;
        }
        if (Objects.nonNull(value = this.redisTemplate.opsForValue().get((Object)key))) {
            return ZKResultMsg.successMsg();
        }
        return ZKResultMsg.failMsg();
    }
}

