/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.app.controller;

import com.zkteco.zkbiosecurity.auth.app.service.AuthAppLoginService;
import com.zkteco.zkbiosecurity.auth.app.vo.AppUserLoginItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.AppResultMessage;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/token"})
public class AppLoginController
extends BaseController {
    @Autowired
    private AuthAppLoginService authAppLoginService;

    @RequestMapping(value={"/login"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public AppResultMessage login(@RequestBody AppUserLoginItem item) {
        AppResultMessage zkResultMsg = new AppResultMessage();
        String loginType = item.getLoginType();
        if (!"PERS".equals(loginType) && !"NORMAL".equals(loginType)) {
            throw ZKBusinessException.errorException((String)"auth_appLogin_loginTypeError", (Object[])new Object[0]);
        }
        try {
            zkResultMsg = this.authAppLoginService.appLogin(loginType, item);
        }
        catch (ZKBusinessException e) {
            this.log.error("login error", (Throwable)e);
            zkResultMsg = AppResultMessage.failMessage((String)e.getMessage());
        }
        return zkResultMsg;
    }
}

