/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisAttributeRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeItem;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAttributeController
extends BaseController
implements VisAttributeRemote {
    @Autowired
    private VisAttributeService visAttributeService;

    @RequiresPermissions(value={"vis:attribute"})
    public ModelAndView index() {
        return new ModelAndView("vis/attribute/visAttribute");
    }

    @RequiresPermissions(value={"vis:attribute:edit", "vis:attribute:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visAttributeService.getItemById(id));
        } else {
            Integer defaultX = 0;
            Integer defaultY = 0;
            Integer maxPositionX = 0;
            Map rowMap = this.visAttributeService.getAllAttrMap();
            for (Integer key : rowMap.keySet()) {
                if (((List)rowMap.get(key)).size() == 1 && (defaultX == 0 || key < defaultX)) {
                    defaultX = key;
                    defaultY = (Integer)((List)rowMap.get(key)).get(0) == 1 ? 2 : 1;
                }
                if (key <= maxPositionX) continue;
                maxPositionX = key;
            }
            if (defaultX != 0 && defaultY != 0) {
                this.request.setAttribute("defaultX", (Object)defaultX);
                this.request.setAttribute("defaultY", (Object)defaultY);
            } else {
                this.request.setAttribute("defaultX", (Object)(maxPositionX + 1));
                this.request.setAttribute("defaultY", (Object)1);
            }
        }
        return new ModelAndView("vis/attribute/editVisAttribute");
    }

    @RequiresPermissions(value={"vis:attribute:edit", "vis:attribute:add"})
    @LogRequest(module="vis_module", object="pers_attribute", opType="common_op_new", requestParams={"attrName"}, opContent="pers_attrDefini_attrName")
    public ZKResultMsg save(VisAttributeItem item) {
        this.visAttributeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:attribute:refresh"})
    public DxGrid list(VisAttributeItem condition) {
        Pager pager = this.visAttributeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:attribute:del"})
    @LogRequest(module="vis_module", object="pers_attribute", opType="common_op_del", requestParams={"attrNames"}, opContent="pers_attrDefini_attrName")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visAttributeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validRowCol() {
        VisAttributeItem item;
        boolean rs = true;
        String id = this.request.getParameter("id");
        String positionX = this.request.getParameter("positionX");
        String positionY = this.request.getParameter("positionY");
        if (!(positionX == null || positionX.equals("") || positionY == null || positionY.equals("") || (item = this.visAttributeService.getItemByPositionXY(Integer.valueOf(Integer.parseInt(positionX)), Integer.valueOf(Integer.parseInt(positionY)))) == null || item.getId().equals(id))) {
            rs = false;
        }
        return rs + "";
    }

    public String validAttrName(@RequestParam(value="attrName") String attrName) {
        VisAttributeItem item = this.visAttributeService.getItemByAttrName(attrName);
        boolean rs = item == null;
        return rs + "";
    }

    public String validExceedFiveTimes(@RequestParam(value="id") String id) {
        boolean rs = true;
        List idList = this.visAttributeService.getIdsByShowTable(true);
        if (StringUtils.isNotBlank((CharSequence)id) && idList.contains(id)) {
            rs = true;
        } else if (idList.size() > 4) {
            rs = false;
        }
        return rs + "";
    }
}

