/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;

enum TDSType {
    BIT1(50),
    INT8(127),
    INT4(56),
    INT2(52),
    INT1(48),
    FLOAT4(59),
    FLOAT8(62),
    DATETIME4(58),
    DATETIME8(61),
    MONEY4(122),
    MONEY8(60),
    BITN(104),
    INTN(38),
    DECIMALN(106),
    NUMERICN(108),
    FLOATN(109),
    MONEYN(110),
    DATETIMEN(111),
    GUID(36),
    DATEN(40),
    TIMEN(41),
    DATETIME2N(42),
    DATETIMEOFFSETN(43),
    BIGCHAR(175),
    BIGVARCHAR(167),
    BIGBINARY(173),
    BIGVARBINARY(165),
    NCHAR(239),
    NVARCHAR(231),
    IMAGE(34),
    TEXT(35),
    NTEXT(99),
    UDT(240),
    XML(241),
    SQL_VARIANT(98);

    private final int intValue;
    private static final int MAXELEMENTS = 256;
    private static final TDSType[] valuesTypes;

    byte byteValue() {
        return (byte)this.intValue;
    }

    private TDSType(int n3) {
        this.intValue = n3;
    }

    static TDSType valueOf(int n2) throws IllegalArgumentException {
        TDSType tDSType;
        if (0 > n2 || n2 >= valuesTypes.length || null == (tDSType = valuesTypes[n2])) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_unknownSSType"));
            Object[] objectArray = new Object[]{new Integer(n2)};
            throw new IllegalArgumentException(messageFormat.format(objectArray));
        }
        return tDSType;
    }

    static {
        valuesTypes = new TDSType[256];
        TDSType[] tDSTypeArray = TDSType.values();
        int n2 = tDSTypeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TDSType tDSType;
            TDSType.valuesTypes[tDSType.intValue] = tDSType = tDSTypeArray[i2];
        }
    }
}

