/*
 * Decompiled with CFR 0.152.
 */
package sun.util.logging;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Date;
import java.util.List;
import sun.util.logging.LoggingProxy;

public class LoggingSupport {
    private static final LoggingProxy proxy = AccessController.doPrivileged(new PrivilegedAction<LoggingProxy>(){

        @Override
        public LoggingProxy run() {
            try {
                Class<?> clazz = Class.forName("java.util.logging.LoggingProxyImpl", true, null);
                Field field = clazz.getDeclaredField("INSTANCE");
                field.setAccessible(true);
                return (LoggingProxy)field.get(null);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new AssertionError((Object)noSuchFieldException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
        }
    });
    private static final String DEFAULT_FORMAT = "%1$tb %1$td, %1$tY %1$tl:%1$tM:%1$tS %1$Tp %2$s%n%4$s: %5$s%6$s%n";
    private static final String FORMAT_PROP_KEY = "java.util.logging.SimpleFormatter.format";

    private LoggingSupport() {
    }

    public static boolean isAvailable() {
        return proxy != null;
    }

    private static void ensureAvailable() {
        if (proxy == null) {
            throw new AssertionError((Object)"Should not here");
        }
    }

    public static List<String> getLoggerNames() {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerNames();
    }

    public static String getLoggerLevel(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getLoggerLevel(string);
    }

    public static void setLoggerLevel(String string, String string2) {
        LoggingSupport.ensureAvailable();
        proxy.setLoggerLevel(string, string2);
    }

    public static String getParentLoggerName(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getParentLoggerName(string);
    }

    public static Object getLogger(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.getLogger(string);
    }

    public static Object getLevel(Object object) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevel(object);
    }

    public static void setLevel(Object object, Object object2) {
        LoggingSupport.ensureAvailable();
        proxy.setLevel(object, object2);
    }

    public static boolean isLoggable(Object object, Object object2) {
        LoggingSupport.ensureAvailable();
        return proxy.isLoggable(object, object2);
    }

    public static void log(Object object, Object object2, String string) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string);
    }

    public static void log(Object object, Object object2, String string, Throwable throwable) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string, throwable);
    }

    public static void log(Object object, Object object2, String string, Object ... objectArray) {
        LoggingSupport.ensureAvailable();
        proxy.log(object, object2, string, objectArray);
    }

    public static Object parseLevel(String string) {
        LoggingSupport.ensureAvailable();
        return proxy.parseLevel(string);
    }

    public static String getLevelName(Object object) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevelName(object);
    }

    public static int getLevelValue(Object object) {
        LoggingSupport.ensureAvailable();
        return proxy.getLevelValue(object);
    }

    public static String getSimpleFormat() {
        return LoggingSupport.getSimpleFormat(true);
    }

    static String getSimpleFormat(boolean bl) {
        String string = (String)AccessController.doPrivileged(new /* Unavailable Anonymous Inner Class!! */);
        if (bl && proxy != null && string == null) {
            string = proxy.getProperty(FORMAT_PROP_KEY);
        }
        if (string != null) {
            try {
                String.format(string, new Date(), "", "", "", "", "");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                string = DEFAULT_FORMAT;
            }
        } else {
            string = DEFAULT_FORMAT;
        }
        return string;
    }
}

