/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.invoke.Invokers;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandleStatics;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeForm;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import sun.invoke.util.BytecodeDescriptor;
import sun.invoke.util.VerifyType;
import sun.invoke.util.Wrapper;
import sun.misc.Unsafe;

public final class MethodType
implements Serializable {
    private static final long serialVersionUID = 292L;
    private final Class<?> rtype;
    private final Class<?>[] ptypes;
    private MethodTypeForm form;
    private MethodType wrapAlt;
    private Invokers invokers;
    static final int MAX_JVM_ARITY = 255;
    static final int MAX_MH_ARITY = 254;
    static final int MAX_MH_INVOKER_ARITY = 253;
    static final WeakInternSet internTable = new WeakInternSet();
    static final Class<?>[] NO_PTYPES = new Class[0];
    private static final MethodType[] objectOnlyTypes = new MethodType[20];
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    private static final long rtypeOffset;
    private static final long ptypesOffset;

    private MethodType(Class<?> clazz, Class<?>[] classArray) {
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        this.rtype = clazz;
        this.ptypes = classArray;
    }

    MethodTypeForm form() {
        return this.form;
    }

    Class<?> rtype() {
        return this.rtype;
    }

    Class<?>[] ptypes() {
        return this.ptypes;
    }

    void setForm(MethodTypeForm methodTypeForm) {
        this.form = methodTypeForm;
    }

    private static void checkRtype(Class<?> clazz) {
        clazz.equals(clazz);
    }

    private static int checkPtype(Class<?> clazz) {
        clazz.getClass();
        if (clazz == Void.TYPE) {
            throw MethodHandleStatics.newIllegalArgumentException("parameter type cannot be void");
        }
        if (clazz == Double.TYPE || clazz == Long.TYPE) {
            return 1;
        }
        return 0;
    }

    private static int checkPtypes(Class<?>[] classArray) {
        int n = 0;
        for (Class<?> clazz : classArray) {
            n += MethodType.checkPtype(clazz);
        }
        MethodType.checkSlotCount(classArray.length + n);
        return n;
    }

    static void checkSlotCount(int n) {
        if ((n & 0xFF) != n) {
            throw MethodHandleStatics.newIllegalArgumentException("bad parameter count " + n);
        }
    }

    private static IndexOutOfBoundsException newIndexOutOfBoundsException(Object object) {
        if (object instanceof Integer) {
            object = "bad index: " + object;
        }
        return new IndexOutOfBoundsException(object.toString());
    }

    public static MethodType methodType(Class<?> clazz, Class<?>[] classArray) {
        return MethodType.makeImpl(clazz, classArray, false);
    }

    public static MethodType methodType(Class<?> clazz, List<Class<?>> list) {
        boolean bl = false;
        return MethodType.makeImpl(clazz, MethodType.listToArray(list), bl);
    }

    private static Class<?>[] listToArray(List<Class<?>> list) {
        MethodType.checkSlotCount(list.size());
        return list.toArray(NO_PTYPES);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2, Class<?> ... classArray) {
        Class[] classArray2 = new Class[1 + classArray.length];
        classArray2[0] = clazz2;
        System.arraycopy(classArray, 0, classArray2, 1, classArray.length);
        return MethodType.makeImpl(clazz, classArray2, true);
    }

    public static MethodType methodType(Class<?> clazz) {
        return MethodType.makeImpl(clazz, NO_PTYPES, true);
    }

    public static MethodType methodType(Class<?> clazz, Class<?> clazz2) {
        return MethodType.makeImpl(clazz, new Class[]{clazz2}, true);
    }

    public static MethodType methodType(Class<?> clazz, MethodType methodType) {
        return MethodType.makeImpl(clazz, methodType.ptypes, true);
    }

    static MethodType makeImpl(Class<?> clazz, Class<?>[] classArray, boolean bl) {
        MethodTypeForm methodTypeForm;
        MethodType methodType;
        MethodType methodType2;
        if (classArray.length == 0) {
            classArray = NO_PTYPES;
            bl = true;
        }
        if ((methodType2 = internTable.get(methodType = new MethodType(clazz, classArray))) != null) {
            return methodType2;
        }
        if (!bl) {
            methodType = new MethodType(clazz, (Class[])classArray.clone());
        }
        methodType.form = methodTypeForm = MethodTypeForm.findForm(methodType);
        return internTable.add(methodType);
    }

    public static MethodType genericMethodType(int n, boolean bl) {
        MethodType methodType;
        MethodType.checkSlotCount(n);
        int n2 = !bl ? 0 : 1;
        int n3 = n * 2 + n2;
        if (n3 < objectOnlyTypes.length && (methodType = objectOnlyTypes[n3]) != null) {
            return methodType;
        }
        Object[] objectArray = new Class[n + n2];
        Arrays.fill(objectArray, Object.class);
        if (n2 != 0) {
            objectArray[n] = Object[].class;
        }
        methodType = MethodType.makeImpl(Object.class, objectArray, true);
        if (n3 < objectOnlyTypes.length) {
            MethodType.objectOnlyTypes[n3] = methodType;
        }
        return methodType;
    }

    public static MethodType genericMethodType(int n) {
        return MethodType.genericMethodType(n, false);
    }

    public MethodType changeParameterType(int n, Class<?> clazz) {
        if (this.parameterType(n) == clazz) {
            return this;
        }
        MethodType.checkPtype(clazz);
        Class[] classArray = (Class[])this.ptypes.clone();
        classArray[n] = clazz;
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    public MethodType insertParameterTypes(int n, Class<?> ... classArray) {
        int n2 = this.ptypes.length;
        if (n < 0 || n > n2) {
            throw MethodType.newIndexOutOfBoundsException(n);
        }
        int n3 = MethodType.checkPtypes(classArray);
        MethodType.checkSlotCount(this.parameterSlotCount() + classArray.length + n3);
        int n4 = classArray.length;
        if (n4 == 0) {
            return this;
        }
        Class<?>[] classArray2 = Arrays.copyOfRange(this.ptypes, 0, n2 + n4);
        System.arraycopy(classArray2, n, classArray2, n + n4, n2 - n);
        System.arraycopy(classArray, 0, classArray2, n, n4);
        return MethodType.makeImpl(this.rtype, classArray2, true);
    }

    public MethodType appendParameterTypes(Class<?> ... classArray) {
        return this.insertParameterTypes(this.parameterCount(), classArray);
    }

    public MethodType insertParameterTypes(int n, List<Class<?>> list) {
        return this.insertParameterTypes(n, MethodType.listToArray(list));
    }

    public MethodType appendParameterTypes(List<Class<?>> list) {
        return this.insertParameterTypes(this.parameterCount(), list);
    }

    MethodType replaceParameterTypes(int n, int n2, Class<?> ... classArray) {
        if (n == n2) {
            return this.insertParameterTypes(n, classArray);
        }
        int n3 = this.ptypes.length;
        if (0 > n || n > n2 || n2 > n3) {
            throw MethodType.newIndexOutOfBoundsException("start=" + n + " end=" + n2);
        }
        int n4 = classArray.length;
        if (n4 == 0) {
            return this.dropParameterTypes(n, n2);
        }
        return this.dropParameterTypes(n, n2).insertParameterTypes(n, classArray);
    }

    public MethodType dropParameterTypes(int n, int n2) {
        Class<?>[] classArray;
        int n3 = this.ptypes.length;
        if (0 > n || n > n2 || n2 > n3) {
            throw MethodType.newIndexOutOfBoundsException("start=" + n + " end=" + n2);
        }
        if (n == n2) {
            return this;
        }
        if (n == 0) {
            classArray = n2 == n3 ? NO_PTYPES : Arrays.copyOfRange(this.ptypes, n2, n3);
        } else if (n2 == n3) {
            classArray = Arrays.copyOfRange(this.ptypes, 0, n);
        } else {
            int n4 = n3 - n2;
            classArray = Arrays.copyOfRange(this.ptypes, 0, n + n4);
            System.arraycopy(this.ptypes, n2, classArray, n, n4);
        }
        return MethodType.makeImpl(this.rtype, classArray, true);
    }

    public MethodType changeReturnType(Class<?> clazz) {
        if (this.returnType() == clazz) {
            return this;
        }
        return MethodType.makeImpl(clazz, this.ptypes, true);
    }

    public boolean hasPrimitives() {
        return this.form.hasPrimitives();
    }

    public boolean hasWrappers() {
        return this.unwrap() != this;
    }

    public MethodType erase() {
        return this.form.erasedType();
    }

    MethodType basicType() {
        return this.form.basicType();
    }

    MethodType invokerType() {
        return this.insertParameterTypes(0, MethodHandle.class);
    }

    public MethodType generic() {
        return MethodType.genericMethodType(this.parameterCount());
    }

    public MethodType wrap() {
        return this.hasPrimitives() ? MethodType.wrapWithPrims(this) : this;
    }

    public MethodType unwrap() {
        MethodType methodType = !this.hasPrimitives() ? this : MethodType.wrapWithPrims(this);
        return MethodType.unwrapWithNoPrims(methodType);
    }

    private static MethodType wrapWithPrims(MethodType methodType) {
        assert (methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonicalize((MethodType)methodType, (int)2, (int)2);
            assert (methodType2 != null);
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    private static MethodType unwrapWithNoPrims(MethodType methodType) {
        assert (!methodType.hasPrimitives());
        MethodType methodType2 = methodType.wrapAlt;
        if (methodType2 == null) {
            methodType2 = MethodTypeForm.canonicalize((MethodType)methodType, (int)3, (int)3);
            if (methodType2 == null) {
                methodType2 = methodType;
            }
            methodType.wrapAlt = methodType2;
        }
        return methodType2;
    }

    public Class<?> parameterType(int n) {
        return this.ptypes[n];
    }

    public int parameterCount() {
        return this.ptypes.length;
    }

    public Class<?> returnType() {
        return this.rtype;
    }

    public List<Class<?>> parameterList() {
        return Collections.unmodifiableList(Arrays.asList(this.ptypes));
    }

    Class<?> lastParameterType() {
        int n = this.ptypes.length;
        return n == 0 ? Void.TYPE : this.ptypes[n - 1];
    }

    public Class<?>[] parameterArray() {
        return (Class[])this.ptypes.clone();
    }

    public boolean equals(Object object) {
        return this == object || object instanceof MethodType && this.equals((MethodType)object);
    }

    private boolean equals(MethodType methodType) {
        return this.rtype == methodType.rtype && Arrays.equals(this.ptypes, methodType.ptypes);
    }

    public int hashCode() {
        int n = 31 + this.rtype.hashCode();
        for (Class<?> clazz : this.ptypes) {
            n = 31 * n + clazz.hashCode();
        }
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        for (int i = 0; i < this.ptypes.length; ++i) {
            if (i > 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(this.ptypes[i].getSimpleName());
        }
        stringBuilder.append(")");
        stringBuilder.append(this.rtype.getSimpleName());
        return stringBuilder.toString();
    }

    boolean isViewableAs(MethodType methodType) {
        if (!VerifyType.isNullConversion(this.returnType(), methodType.returnType())) {
            return false;
        }
        int n = this.parameterCount();
        if (n != methodType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (VerifyType.isNullConversion(methodType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    boolean isCastableTo(MethodType methodType) {
        int n = this.parameterCount();
        return n == methodType.parameterCount();
    }

    boolean isConvertibleTo(MethodType methodType) {
        if (!MethodType.canConvert(this.returnType(), methodType.returnType())) {
            return false;
        }
        int n = this.parameterCount();
        if (n != methodType.parameterCount()) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (MethodType.canConvert(methodType.parameterType(i), this.parameterType(i))) continue;
            return false;
        }
        return true;
    }

    static boolean canConvert(Class<?> clazz, Class<?> clazz2) {
        if (clazz == clazz2 || clazz2 == Object.class) {
            return true;
        }
        if (clazz.isPrimitive()) {
            if (clazz == Void.TYPE) {
                return true;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz);
            if (clazz2.isPrimitive()) {
                return Wrapper.forPrimitiveType(clazz2).isConvertibleFrom(wrapper);
            }
            return clazz2.isAssignableFrom(wrapper.wrapperType());
        }
        if (clazz2.isPrimitive()) {
            if (clazz2 == Void.TYPE) {
                return true;
            }
            Wrapper wrapper = Wrapper.forPrimitiveType(clazz2);
            if (clazz.isAssignableFrom(wrapper.wrapperType())) {
                return true;
            }
            return Wrapper.isWrapperType(clazz) && wrapper.isConvertibleFrom(Wrapper.forWrapperType(clazz));
        }
        return true;
    }

    int parameterSlotCount() {
        return this.form.parameterSlotCount();
    }

    Invokers invokers() {
        Invokers invokers = this.invokers;
        if (invokers != null) {
            return invokers;
        }
        this.invokers = invokers = new Invokers(this);
        return invokers;
    }

    int parameterSlotDepth(int n) {
        if (n < 0 || n > this.ptypes.length) {
            this.parameterType(n);
        }
        return this.form.parameterToArgSlot(n - 1);
    }

    int returnSlotCount() {
        return this.form.returnSlotCount();
    }

    public static MethodType fromMethodDescriptorString(String string, ClassLoader classLoader) throws IllegalArgumentException, TypeNotPresentException {
        if (!string.startsWith("(") || string.indexOf(41) < 0 || string.indexOf(46) >= 0) {
            throw new IllegalArgumentException("not a method descriptor: " + string);
        }
        List<Class<?>> list = BytecodeDescriptor.parseMethod(string, classLoader);
        Class<?> clazz = list.remove(list.size() - 1);
        MethodType.checkSlotCount(list.size());
        Class<?>[] classArray = MethodType.listToArray(list);
        return MethodType.makeImpl(clazz, classArray, true);
    }

    public String toMethodDescriptorString() {
        return BytecodeDescriptor.unparse((MethodType)this);
    }

    static String toFieldDescriptorString(Class<?> clazz) {
        return BytecodeDescriptor.unparse(clazz);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.returnType());
        objectOutputStream.writeObject(this.parameterArray());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        Class clazz = (Class)objectInputStream.readObject();
        Class[] classArray = (Class[])objectInputStream.readObject();
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        classArray = (Class[])classArray.clone();
        this.MethodType_init(clazz, classArray);
    }

    private MethodType() {
        this.rtype = null;
        this.ptypes = null;
    }

    private void MethodType_init(Class<?> clazz, Class<?>[] classArray) {
        MethodType.checkRtype(clazz);
        MethodType.checkPtypes(classArray);
        ((Unsafe)((Object)MethodHandleStatics.UNSAFE)).putObject(this, rtypeOffset, clazz);
        ((Unsafe)((Object)MethodHandleStatics.UNSAFE)).putObject(this, ptypesOffset, classArray);
    }

    private Object readResolve() {
        return MethodType.methodType(this.rtype, this.ptypes);
    }

    static {
        try {
            rtypeOffset = ((Unsafe)((Object)MethodHandleStatics.UNSAFE)).objectFieldOffset(MethodType.class.getDeclaredField("rtype"));
            ptypesOffset = ((Unsafe)((Object)MethodHandleStatics.UNSAFE)).objectFieldOffset(MethodType.class.getDeclaredField("ptypes"));
        }
        catch (Exception exception) {
            throw new Error(exception);
        }
    }
}

