/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.sis.remote.SisParamsRemote;
import com.zkteco.zkbiosecurity.sis.service.SisParamsService;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SisParamsController
extends BaseController
implements SisParamsRemote {
    @Autowired
    private SisParamsService sisParamsService;

    public ModelAndView index() {
        this.request.setAttribute("carBottomInfoAddr", (Object)this.sisParamsService.getSisParam("sis.carBottomInfoAddr"));
        this.request.setAttribute("tcpPort", (Object)this.sisParamsService.getSisParam("sis.tcpPort"));
        return new ModelAndView("sis/params/params");
    }

    @RequiresPermissions(value={"sis:params:edit"})
    @LogRequest(module="sis_module", object="common_leftMenu_paramSet", opType="common_leftMenu_paramSet", opContent="common_leftMenu_paramSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        params.put("sis.tcpPort", params.get("sis.tcpPort"));
        params.put("sis.carBottomInfoAddr", params.get("sis.carBottomInfoAddr"));
        this.sisParamsService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public String checkPort(@RequestParam(value="sis.tcpPort") String tcpPort) {
        boolean flag = true;
        int port = Integer.parseInt(tcpPort);
        InetAddress address = null;
        try {
            address = InetAddress.getByName("127.0.0.1");
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        try {
            String portStr = this.sisParamsService.getSisParam("sis.tcpPort");
            if (!portStr.equals(tcpPort)) {
                Socket socket = new Socket(address, port);
                socket.close();
                flag = false;
            }
        }
        catch (IOException e) {
            this.log.info("\u8bbe\u7f6etcp\u670d\u52a1\u7aef\u53e3" + port + "\u5b8c\u6210\uff01");
        }
        return String.valueOf(flag);
    }
}

