/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.util.ui;

import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import javax.swing.UIManager;
import net.sourceforge.jnlp.runtime.JNLPRuntime;

public class SwingHelpers {
    public static String LABEL_TEXT_PREFIX = "<html>";
    public static String LABEL_TEXT_POSTFIX = "</html>";

    public static void enableDefaultLaF() {
        String className = null;
        if (JNLPRuntime.isWindows()) {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                className = info.getClassName();
                break;
            }
        } else {
            className = UIManager.getSystemLookAndFeelClassName();
        }
        if (null != className) {
            try {
                UIManager.setLookAndFeel(className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String wrapLabelText(String text) {
        if (null == text || text.isEmpty()) {
            return "";
        }
        if (text.length() > LABEL_TEXT_PREFIX.length() && LABEL_TEXT_PREFIX.equalsIgnoreCase(text.substring(0, LABEL_TEXT_PREFIX.length()))) {
            return text;
        }
        return LABEL_TEXT_PREFIX + text + LABEL_TEXT_POSTFIX;
    }

    public static String shortenText(String text, int maxLength) {
        if (null == text) {
            return "";
        }
        if (text.length() < maxLength) {
            return text;
        }
        return text.substring(0, maxLength) + " ...";
    }

    public static String linkify(String url) {
        return "<html><a href=\"" + url + "\">" + url + "</a></html>";
    }

    public static class OpenUrlInBrowserListener
    extends MouseAdapter {
        private final String url;

        public OpenUrlInBrowserListener(String url) {
            this.url = url;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            try {
                Desktop.getDesktop().browse(new URI(this.url));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

