/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.sis.init;

import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicService;
import com.zkteco.zkbiosecurity.sis.service.SisTipPicTypeService;
import com.zkteco.zkbiosecurity.sis.vo.SisTipPicTypeItem;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=500)
public class SisInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private SisTipPicTypeService sisTipPicTypeService;
    @Autowired
    private SisTipPicService sisTipPicService;
    @Value(value="${system.productCode}")
    private String productCode;
    @Value(value="${system.language:zh_CN}")
    private String language;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("SisInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initSisTipPicType();
            this.initSisTipPic();
            this.initSisParams();
            this.baseSysParamService.setAlreadyInitModule("SisInit");
        }
    }

    public void initSisTipPicType() {
        String[] nameArray;
        for (String name : nameArray = new String[]{I18nUtil.i18nCode((String)"sis_picType_knife", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sis_picType_cash", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sis_picType_boom", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sis_picType_fruit", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sis_picType_guns", (Object[])new Object[0]), I18nUtil.i18nCode((String)"sis_picType_else", (Object[])new Object[0])}) {
            SisTipPicTypeItem item = new SisTipPicTypeItem();
            item.setName(name);
            if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_knife", (Object[])new Object[0]))) {
                item.setType("Knives");
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_cash", (Object[])new Object[0]))) {
                item.setType("Cashes");
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_boom", (Object[])new Object[0]))) {
                item.setType("Explosives");
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_fruit", (Object[])new Object[0]))) {
                item.setType("Fruits");
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_guns", (Object[])new Object[0]))) {
                item.setType("Guns");
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)I18nUtil.i18nCode((String)"sis_picType_else", (Object[])new Object[0]))) {
                item.setType("Others");
            }
            this.sisTipPicTypeService.initData(item);
        }
    }

    public void initSisTipPic() {
        this.sisTipPicService.initData();
    }

    private void initAuthPermission() {
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        AuthPermissionItem systemItem = new AuthPermissionItem("Sis", "sis_module", "sis", "system", "true", Integer.valueOf(1));
        systemItem = this.authPermissionService.initData(systemItem);
        parentMenuItem = new AuthPermissionItem("SisDeviceManager", "sis_device_manager", "sis:device:manager", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setActionLink("/sisDevice.do");
        parentMenuItem.setImg("sis_device.png");
        parentMenuItem.setImgHover("sis_device_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("SisHomePage", "sis_home_page", "sis:homePage", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisHomePage.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        childMenuItem = new AuthPermissionItem("SisDevice", "sis_dev_device", "sis:device", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisDevice.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceRefresh", "common_op_refresh", "sis:device:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceAdd", "common_op_new", "sis:device:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceEdit", "common_op_edit", "sis:device:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceDel", "common_op_del", "sis:device:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisCarUnder", "sis_car_under", "sis:carUnder", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisCarUnder.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisCarUnderRefresh", "common_op_refresh", "sis:carUnder:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisCarUnderAdd", "common_op_new", "sis:carUnder:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisCarUnderEdit", "common_op_edit", "sis:carUnder:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisCarUnderDel", "common_op_del", "sis:carUnder:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("SisPersonManager", "sis_person_manager", "sis:person:manager", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setActionLink("/sisPersonAddDevice.do");
        parentMenuItem.setImg("pers.png");
        parentMenuItem.setImgHover("pers_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("SisPersonAddDevice", "sis_person_addByPerson", "sis:personAddDevice", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisPersonAddDevice.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPersonAddDeviceRefresh", "common_op_refresh", "sis:personAddDevice:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPersonAddDeviceAdd", "common_op_new", "sis:personAddDevice:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPersonAddDeviceEdit", "common_op_edit", "sis:personAddDevice:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPersonAddDeviceDel", "common_op_del", "sis:personAddDevice:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisDeviceAddPerson", "sis_person_addByDevice", "sis:deviceAddPerson", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisDeviceAddPerson.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceAddPersonRefresh", "common_op_refresh", "sis:deviceAddPerson:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceAddPersonAdd", "common_op_new", "sis:deviceAddPerson:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceAddPersonEdit", "common_op_edit", "sis:deviceAddPerson:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDeviceAddPersonDel", "common_op_del", "sis:deviceAddPerson:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("SisMonitor", "sis_leftMenu_devMonitor", "sis:monitor", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("sis_RTMonitor.png");
        parentMenuItem.setImgHover("sis_RTMonitor.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("SisRTMonitor", "sis_leftMenu_realTimeMonitor", "sis:rtMonitor", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisRTMonitor.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMonitorRefresh", "common_op_refresh", "sis:Monitor:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisMap", "sis_leftMenu_monitorMap", "sis:map", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisMap.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapRefresh", "common_op_refresh", "sis:map:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapAdd", "common_op_new", "sis:map:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapEdit", "common_op_edit", "sis:map:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapDel", "common_op_del", "sis:map:del", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapSaveMapPos", "common_op_savePositon", "sis:map:saveMapPos", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapAddDeviceToMap", "sis_person_addDevice", "sis:map:addDeviceToMap", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisMapAddDoorToMap", "sis_gate_addDevice", "sis:map:addDoorToMap", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("SisTipManager", "sis_tip_manager", "sis:sisTipPic.sisTipPic:manager", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setActionLink("/sisTipPic.do");
        parentMenuItem.setImg("pers_card.png");
        parentMenuItem.setImgHover("pers_card_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("SisTipPic", "sis_tip_pic", "sis:sisTipPic", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisTipPic.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipPicRefresh", "common_op_refresh", "sis:sisTipPic:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipPicAdd", "common_op_new", "sis:sisTipPic:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipPicEdit", "common_op_edit", "sis:sisTipPic:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipPicDel", "common_op_del", "sis:sisTipPic:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisTipStrategy", "sis_tip_strategy", "sis:tipStrategy", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisTipStrategy.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipStrategyRefresh", "common_op_refresh", "sis:tipStrategy:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipTipStrategyAdd", "common_op_new", "sis:tipStrategy:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTrainingTipEdit", "common_op_edit", "sis:tipStrategy:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipTipStrategyDel", "common_op_del", "sis:tipStrategy:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisTipStgAddPic", "sis_tip_stgAddPic", "sis:tipStgAddPic", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisTipStgAddPic.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipStgAddPicRefresh", "common_op_refresh", "sis:tipStgAddPic:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipStgAddPicAdd", "common_op_new", "sis:tipStgAddPic:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipStgAddPicEdit", "common_op_edit", "sis:tipStgAddPic:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisTipStgAddPicDel", "common_op_del", "sis:tipStgAddPic:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("SisReports", "common_leftMenu_reports", "sis:reports", "menu", "true", Integer.valueOf(4));
        parentMenuItem.setParentId(systemItem.getId());
        parentMenuItem.setImg("comm_reports.png");
        parentMenuItem.setImgHover("comm_reports_over.png");
        parentMenuItem = this.authPermissionService.initData(parentMenuItem);
        childMenuItem = new AuthPermissionItem("SisPackageTransaction", "sis_package_transaction", "sis:packageTransaction:Transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisPackageTransaction.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPackageTransactionRefresh", "common_op_refresh", "sis:packageTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisPackageTransactionExport", "common_op_export", "sis:packageTransaction:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisDangerousGoodsTransaction", "sis_dangerous_goods_transaction", "sis:dangerousGoodsTransaction:Transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisDangerousGoodsTransaction.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDangerousGoodsTransactionRefresh", "common_op_refresh", "sis:dangerousGoodsTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisDangerousGoodsTransactionExport", "common_op_export", "sis:dangerousGoodsTransaction:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisAlarmTransaction", "sis_report_alarm", "sis:Alarm:Transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisAlarmTransaction.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisAlarmTransactionRefresh", "common_op_refresh", "sis:AlarmTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisAlarmTransactionExport", "common_op_export", "sis:AlarmTransaction:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisFluidTransaction", "sis_report_fluid", "sis:Fluid:Transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisFluidTransaction.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisFluidTransactionRefresh", "common_op_refresh", "sis:FluidTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisFluidTransactionExport", "common_op_export", "sis:FluidTransaction:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisNarcoticsExplosiveTransaction", "sis_report_narcoticsExplosive", "sis:NarcoticsExplosive:Transaction", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisIEDTransaction.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisNarcoticsExplosiveTransactionRefresh", "common_op_refresh", "sis:NarcoticsExplosiveTransaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisNarcoticsExplosiveTransactionExport", "common_op_export", "sis:NarcoticsExplosiveTransaction:export", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(buttonMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("SisCarUnderInfo", "sis_report_carBottomScan", "sis:carUnderInfo", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("/sisCarUnderInfo.do");
        childMenuItem = this.authPermissionService.initData(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("SisCarUnderInfoRefresh", "common_op_refresh", "sis:carUnderInfo:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
    }

    public void initSisParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("sis.carBottomInfoAddr", "D:/CarCheckImageUpload", "\u8f66\u724c\u3001\u8f66\u5e95\u7167\u7247\u5b58\u653e\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("sis.tcpPort", "6666", "tcp\u670d\u52a1\u7aef\u53e3"));
        File file = new File("D:/CarCheckImageUpload");
        if (!file.exists()) {
            file.mkdir();
        }
    }
}

