/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.posid.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.posid.remote.PosIDRefundRemote;
import com.zkteco.zkbiosecurity.posid.service.PosIDAccountService;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PosIDRefundController
extends BaseController
implements PosIDRefundRemote {
    @Autowired
    private PosIDAccountService posIDAccountService;

    @RequiresPermissions(value={"posid:refund"})
    public ModelAndView index() {
        return new ModelAndView("posid/refund/posIDRefund");
    }

    @RequiresPermissions(value={"posid:refund:edit"})
    public ModelAndView edit(String id) {
        return new ModelAndView("posid/refund/editPosIDRefund");
    }

    @RequiresPermissions(value={"posid:refund:del"})
    @LogRequest(module="posid_module", object="posid_op_refund", opType="common_op_del", requestParams={"ids"}, opContent="posid_common_id")
    public ZKResultMsg delete(String ids) {
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"posid:refund:edit"})
    @LogRequest(module="posid_module", object="posid_leftMenu_cardBusiness", opType="posid_op_refund", requestParams={"deptName"}, opContent="posid_card_personNum")
    public ZKResultMsg save() {
        Integer money = Integer.parseInt(this.request.getParameter("refundSolde"));
        String accountNo = this.request.getParameter("accountNo");
        ZKResultMsg res = this.posIDAccountService.refund(money, accountNo);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }
}

